DELIMITER $$
DROP PROCEDURE IF EXISTS V20241226142756__Create_control_panel_sysmod $$
CREATE PROCEDURE V20241226142756__Create_control_panel_sysmod()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='control_panel_sysmod')) THEN 
create table control_panel_sysmod (
id bigint not null AUTO_INCREMENT,
controlPanelId bigint not null,
moduleId bigint default null,
subModuleId bigint default null,
lastUpdatedBy bigint NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP on update current_timestamp,
PRIMARY KEY (id),
FOREIGN KEY (controlPanelId) References portals(id),
FOREIGN KEY (moduleId) References system_modules(id),
FOREIGN KEY (subModuleId) References system_modules(id),
FOREIGN KEY (lastUpdatedBy) References users(id)
); 
END IF;

END $$
CALL V20241226142756__Create_control_panel_sysmod () $$ 
DROP PROCEDURE IF EXISTS V20241226142756__Create_control_panel_sysmod $$ 
DELIMITER ;