DELIMITER $$
DROP PROCEDURE IF EXISTS V20241230114634__Create_xeroReceiptMapping $$
CREATE PROCEDURE V20241230114634__Create_xeroReceiptMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='xero_receipt_mapping')) THEN 
CREATE TABLE xero_receipt_mapping (
    id bigint NOT NULL AUTO_INCREMENT,
    xeroBankTransactionID varchar(255) NOT NULL,
	receiptNumber varchar(255) NOT NULL,
    academiaReceiptHeaderId bigint NOT NULL,
    xeroBankTransactionsType varchar(255) NOT NULL,
	lineAmount double default NULL,
    xeroUserId varchar(255) NOT NULL,
    academiaUserId bigint NOT NULL,
	academyLocationId bigint NOT NULL,
	error TEXT default NULL,
    xeroStatus varchar(255) default null,
    createdDate DATE NULL,
    lastUpdatedBy bigint NOT NULL,
    lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_xero_receipt_mapping_lastUpdatedBy_idx (lastUpdatedBy),
  KEY fk_xero_receipt_mapping_academiaReceiptHeaderId_idx (academiaReceiptHeaderId),
  KEY fk_xero_receipt_mapping_academiaUserId_idx (academiaUserId),
  KEY fk_xero_receipt_mapping_academyLocationId_idx (academyLocationId),
  CONSTRAINT fk_xero_receipt_mapping_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id),
  CONSTRAINT fk_xero_receipt_mapping_academiaReceiptHeaderId FOREIGN KEY (academiaReceiptHeaderId) REFERENCES receipt_header (id),
  CONSTRAINT fk_xero_receipt_mapping_academiaUserId FOREIGN KEY (academiaUserId) REFERENCES users (id),
  CONSTRAINT fk_xero_receipt_mapping_academyLocationId FOREIGN KEY (academyLocationId) REFERENCES academy_location (id)
  ) ENGINE=InnoDB;
END IF; 

END $$
CALL V20241230114634__Create_xeroReceiptMapping () $$ 
DROP PROCEDURE IF EXISTS V20241230114634__Create_xeroReceiptMapping $$ 
DELIMITER ;