DELIMITER $$
DROP PROCEDURE IF EXISTS V20250124123348__Alter_lessonPlanSubObjective $$
CREATE PROCEDURE V20250124123348__Alter_lessonPlanSubObjective()
BEGIN

IF NOT EXISTS ((SELECT * FROM   INFORMATION_SCHEMA.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'lesson_plan_sub_objective' AND COLUMN_NAME = 'programLearningOutcomeId')) THEN 
ALTER TABLE `lesson_plan_sub_objective` 
ADD COLUMN `programLearningOutcomeId` BIGINT NULL DEFAULT NULL;
END IF;

IF NOT EXISTS (SELECT index_name FROM information_schema.statistics where table_schema=database() and table_name='lesson_plan_sub_objective' and index_name='RefprogramLearningOutcome_idx') then
ALTER TABLE lesson_plan_sub_objective ADD INDEX `RefprogramLearningOutcome_idx` (`programLearningOutcomeId` ASC);
END IF;

IF NOT EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='RefprogramLearningOutcome' AND table_name='lesson_plan_sub_objective') then
ALTER TABLE `lesson_plan_sub_objective` 
ADD CONSTRAINT `RefprogramLearningOutcome`
  FOREIGN KEY (`programLearningOutcomeId`)
  REFERENCES `program_learning_outcome_csm` (`id`);
END IF; 

IF NOT EXISTS ((SELECT * FROM   INFORMATION_SCHEMA.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'lesson_plan_sub_objective' AND COLUMN_NAME = 'dublinDescriptorId')) THEN 
ALTER TABLE `lesson_plan_sub_objective`
ADD COLUMN `dublinDescriptorId` BIGINT NULL DEFAULT NULL;
END IF; 

IF NOT EXISTS (SELECT index_name FROM information_schema.statistics where table_schema=database() and table_name='lesson_plan_sub_objective' and index_name='RefdublinDescriptor_idx') then
ALTER TABLE lesson_plan_sub_objective ADD INDEX `RefdublinDescriptor_idx` (`dublinDescriptorId` ASC);
END IF;

IF NOT EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='RefdublinDescriptor' AND table_name='lesson_plan_sub_objective') then
ALTER TABLE `lesson_plan_sub_objective` 
ADD CONSTRAINT `RefdublinDescriptor`
  FOREIGN KEY (`dublinDescriptorId`)
  REFERENCES `dublin_descriptors_csm` (`id`);
END IF; 

END $$
CALL V20250124123348__Alter_lessonPlanSubObjective() $$
DROP PROCEDURE IF EXISTS V20250124123348__Alter_lessonPlanSubObjective $$
DELIMITER ;