DELIMITER $$
DROP PROCEDURE IF EXISTS V20250218164652__Update_debarment_reason_csm $$
CREATE PROCEDURE V20250218164652__Update_debarment_reason_csm()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from standard_master where tableName="debarment_reasons")) THEN 
	SET @standardMasterId = (select id from standard_master where tableName="debarment_reasons");
    
IF NOT EXISTS ((SELECT * FROM standard_master_items where standardMasterId = @standardMasterId AND dbFieldName='academyLocation'))THEN 
	INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
	VALUES ('academyLocation','ACADEMY_LOCATION',@standardMasterId,'multiselectcombofield',NULL,3,NULL,NULL,NULL,NULL,0,0,1,NULL,NULL,NULL,1,now());
END IF;
    
IF NOT EXISTS ((SELECT * FROM standard_master_items where standardMasterId = @standardMasterId AND dbFieldName='active'))THEN 
	INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
	VALUES ('active','ACTIVE',@standardMasterId,'Boolean',NULL,4,NULL,NULL,NULL,NULL,0,0,1,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'ACADEMY_LOCATION')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('TRANSLATIONS', 'ACADEMY_LOCATION', 'Academy Location', 'Academy Location','Akademie ligging','Địa điểm học viện',now(),1);
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'ACTIVE')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('TRANSLATIONS', 'ACTIVE', 'Active', 'Active','Aktief','Tích cực',now(),1);
	END IF;
    END IF;
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250218164652__Update_debarment_reason_csm () $$
DROP PROCEDURE IF EXISTS V20250218164652__Update_debarment_reason_csm $$
DELIMITER ;