DELIMITER $$

DROP PROCEDURE IF EXISTS V20250325142702__Create_Student_Mark_Remark_Entry $$

CREATE PROCEDURE V20250325142702__Create_Student_Mark_Remark_Entry()
BEGIN
    IF NOT EXISTS (
        SELECT * FROM information_schema.TABLES 
        WHERE table_schema = DATABASE() AND table_name = 'student_mark_remark_entry'
    ) THEN
        CREATE TABLE student_mark_remark_entry (
            id BIGINT(20) NOT NULL AUTO_INCREMENT,
            columnCode VARCHAR(255) NOT NULL,
            isVisible BIT,
            lastUpdatedBy BIGINT(20) NOT NULL,
            lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    END IF;

    SET @currentTimeStamp = CURRENT_TIMESTAMP;
    SET @standardMasterMaxId = (SELECT IFNULL(MAX(id), 0) FROM standard_master);

    IF NOT EXISTS (
        SELECT * FROM standard_master WHERE tableName = 'student_mark_remark_entry'
    ) THEN
        INSERT INTO standard_master (id, tableName, masterName, moduleName, filterCode, whetherChild, whetherParent, lastUpdatedBy, lastUpdate)
        VALUES (@standardMasterMaxId + 1, 'student_mark_remark_entry', 'student_mark_remark_entry', 'Examinations', 'COMMON_MASTER', 0, 0, 1, NOW());
    END IF;

    SET @standardMasterId = (SELECT id FROM standard_master WHERE tableName = 'student_mark_remark_entry');
    SET @ItemsMaxId = (SELECT IFNULL(MAX(id), 0) FROM standard_master_items);

    IF NOT EXISTS (
        SELECT * FROM standard_master_items 
        WHERE standardMasterId = @standardMasterId AND fieldLabel = 'COLUMN_NAME'
    ) THEN
        INSERT INTO standard_master_items (id, dbFieldName, fieldLabel, standardMasterId, fieldType, diaplayOrder, whetherForeignKey, whetherShortCode, whetherReadOnly, wheherNullable, lastUpdatedBy, lastUpdate)
        VALUES (@ItemsMaxId + 1, 'columnCode', 'COLUMN_NAME', @standardMasterId, 'varchar', 1, 0, 0, 1, 0, 1, NOW());
        SET @ItemsMaxId = @ItemsMaxId + 1;
    END IF;

    IF NOT EXISTS (
        SELECT * FROM standard_master_items 
        WHERE standardMasterId = @standardMasterId AND fieldLabel = 'Visibility'
    ) THEN
        INSERT INTO standard_master_items (id, dbFieldName, fieldLabel, standardMasterId, fieldType, emunType, diaplayOrder, whetherForeignKey, whetherShortCode, whetherReadOnly, wheherNullable, maxLength, lastUpdatedBy, lastUpdate)
        VALUES (@ItemsMaxId + 1, 'isVisible', 'Visibility', @standardMasterId, 'Enum', 'VISIBILITY', 2, 0, 0, 0, 1, 8, 1, NOW());
    END IF;

    IF NOT EXISTS (
        SELECT * FROM picklist_enum WHERE enumType = 'VISIBILITY' AND code = 'VISIBLE'
    ) THEN
        INSERT INTO picklist_enum (enumType, code, enumValue)
        VALUES ('VISIBILITY', 'VISIBLE', 'Visible');
    END IF;

    IF NOT EXISTS (
        SELECT * FROM picklist_enum WHERE enumType = 'VISIBILITY' AND code = 'HIDE'
    ) THEN
        INSERT INTO picklist_enum (enumType, code, enumValue)
        VALUES ('VISIBILITY', 'HIDE', 'Hide');
    END IF;

    IF NOT EXISTS (
        SELECT * FROM student_mark_remark_entry WHERE columnCode = 'SIMILARITY_INDEX'
    ) THEN
        INSERT INTO student_mark_remark_entry (columnCode, isVisible, lastUpdate, lastUpdatedBy) VALUES
        ('Similarity Index (%)', TRUE, NOW(), 1),
        ('Mark Entry Status', TRUE, NOW(), 1),
        ('Max Marks / Grade', TRUE, NOW(), 1),
        ('Marks / Grade Obtained', TRUE, NOW(), 1),
        ('Penalty Marks', FALSE, NOW(), 1),
        ('Grace Marks', FALSE, NOW(), 1),
        ('Total Marks', FALSE, NOW(), 1),
        ('Absent Status', TRUE, NOW(), 1),
        ('Remark Entry Status', TRUE, NOW(), 1),
        ('Remark', TRUE, NOW(), 1),
        ('Remark Actions', TRUE, NOW(), 1),
        ('Offered US Credits', FALSE, NOW(), 1),
        ('Offered ECTS Credits', FALSE, NOW(), 1),
        ('Obtained US Credits', FALSE, NOW(), 1),
        ('Obtained ECTS Credits', FALSE, NOW(), 1),
        ('Offered Marks / Grades', FALSE, NOW(), 1),
        ('Course Average', FALSE, NOW(), 1),
        ('Special Grade', FALSE, NOW(), 1),
        ('Status', FALSE, NOW(), 1),
        ('Retake Course', FALSE, NOW(), 1),
        ('Resit', FALSE, NOW(), 1);
    END IF;

    IF NOT EXISTS (
        SELECT * FROM ui_translation WHERE objectName = 'masterNames' AND keyName = 'student_mark_remark_entry'
    ) THEN
        INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
        VALUES ('masterNames', 'student_mark_remark_entry', 'Student Mark / Remark Entry', 'Student Mark / Remark Entry', 'Studente punt opmerkingsinskrywing', 'Nhập nhận xét điểm học sinh', NOW(), 1);
    END IF;

END $$

CALL V20250325142702__Create_Student_Mark_Remark_Entry() $$

DROP PROCEDURE IF EXISTS V20250325142702__Create_Student_Mark_Remark_Entry $$

DELIMITER ;