DELIMITER $$
DROP PROCEDURE IF EXISTS V20250401163543__Update_QrScannerPushNotificationForCourse $$
CREATE PROCEDURE V20250401163543__Update_QrScannerPushNotificationForCourse()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='QR_SCANNER_PUSH_NOTIFICATION_FOR_COURSE_WISE_DL')) THEN 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='QR_SCANNER_PUSH_NOTIFICATION_FOR_COURSE_WISE_DL');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
        sca.id AS USER_ID  
    FROM
        student_course_attendance sca
    WHERE
        sca.id IN (namedParams)'
WHERE
    (`dataProviderId` = @dtproviderId);
END IF; 

IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='QR_SCANNER_PUSH_NOTIFICATION_FOR_COURSE_WISE_RCPNT')) THEN 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='QR_SCANNER_PUSH_NOTIFICATION_FOR_COURSE_WISE_RCPNT');   
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
        T3.id AS ID,
        group_concat(distinct f.deviceTokenId) AS DEVICE_ID,
        \'QR_SCANNER\' AS MSG_CATEGORY
    FROM
        student_course_attendance sca
            JOIN
        student_course_enrollment sce ON sce.sectionId = sca.sectionId
            AND sce.courseVarientId = sca.variantId
            JOIN
        admission AS T2 ON T2.id = sce.admissionId
            JOIN
        users AS T3 ON T3.id = T2.studentId
        join fire_base_persons_info f on f.userId=T3.id
    WHERE
        sca.id IN (namedParams)
            AND sce.exitDate IS NULL
            AND sce.isCurrentSection = TRUE
            AND DATE(sce.enrollmentDate) <= DATE(sca.dateOfAttendance)
            AND T2.activeStatus = TRUE
            AND NOT EXISTS( SELECT 
                1
            FROM
                student_apply_hold_category H
            WHERE
                H.studentId = T3.id)
    GROUP BY T3.id',
    `jsonString` = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        }
    ]
}'
WHERE
    (`dataProviderId` = @dtproviderId);

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250401163543__Update_QrScannerPushNotificationForCourse () $$
DROP PROCEDURE IF EXISTS V20250401163543__Update_QrScannerPushNotificationForCourse $$
DELIMITER ;