DELIMITER $$

DROP PROCEDURE IF EXISTS sageReceipts $$

CREATE PROCEDURE sageReceipts( IN lastUpdate DATETIME, IN receiptStatus TEXT)
BEGIN
    IF receiptStatus = 'CANCELLED' THEN
		SELECT 'NUMERO RECU PAIEMENT' receiptNo,
		'DATE PAIEMENT' receiptDate,
		'MATRICULE ETUDIANT' studentId,
		'PRENOM ET NOM' studentName,
		'FILIERE' programName,
		'SEMESTRE CONCERNE' period,
		'LIBELLE PAIEMENT' paymentMode,
		'MONTANT' amount,
		'STATUT' as cancelStatus,
		'RAISON DE L''ANNULATION' as cancelNarration
		UNION ALL
		select receipt.receiptNo
		as receiptNo, receipt.transactionDate as receiptDate, u.code as studentId, u.firstName as studentName, p.programName as programName, period.programPeriodName as period,
		receipt.voucherMode as paymentMode, receipt.amount as amount,
		'Cancelled' as cancelStatus,
		receipt.cancellationNarration as cancelNarration
		from receipt_header receipt
		inner join students s on receipt.studentId = s.userId
		inner join users u on s.userId = u.id
		inner join admission a on a.studentId = u.id and a.activeStatus=true
		inner join program_batch_students pbs on pbs.admissionId = a.id and pbs.exitDate is null
		inner join prog_batch_period_config period on pbs.progBatchPeriodConfigId = period.id
		inner join academic_term aterm ON period.academicTermId = aterm.id and aterm.whetherCurrentAcademicTerm = true
		inner join batches b on pbs.programBatchId = b.id
		inner join programs p on b.programId = p.id
		where receipt.creationDateTime > lastUpdate
		and receipt.voucherType = 'RECEIPT'
		and receipt.status = 'CANCELLED';
    ELSE
		SELECT 'NUMERO RECU PAIEMENT' receiptNo,
		'DATE PAIEMENT' receiptDate,
		'MATRICULE ETUDIANT' studentId,
		'PRENOM ET NOM' studentName,
		'FILIERE' programName,
		'SEMESTRE CONCERNE' period,
		'LIBELLE PAIEMENT' paymentMode,
		'MONTANT' amount,
		'STATUT' as cancelStatus,
		'RAISON DE L''ANNULATION' as cancelNarration
		UNION ALL
		select receipt.receiptNo
		as receiptNo, receipt.transactionDate as receiptDate, u.code as studentId, u.firstName as studentName, p.programName as programName, period.programPeriodName as period,
		receipt.voucherMode as paymentMode, receipt.amount as amount,
		'' as cancelStatus,
		receipt.cancellationNarration as cancelNarration
		from receipt_header receipt
		inner join students s on receipt.studentId = s.userId
		inner join users u on s.userId = u.id
		inner join admission a on a.studentId = u.id and a.activeStatus=true
		inner join program_batch_students pbs on pbs.admissionId = a.id and pbs.exitDate is null
		inner join prog_batch_period_config period on pbs.progBatchPeriodConfigId = period.id
		inner join academic_term aterm ON period.academicTermId = aterm.id and aterm.whetherCurrentAcademicTerm = true
		inner join batches b on pbs.programBatchId = b.id
		inner join programs p on b.programId = p.id
		where receipt.creationDateTime >'2000-11-23 12:29:28'
		and receipt.voucherType = 'RECEIPT'
		and receipt.status != 'CANCELLED';
    END IF;
	
END $$

DELIMITER ;
