DELIMITER $$
DROP PROCEDURE IF EXISTS V20250414175127__Create_CreateActionReasonCSM $$
CREATE PROCEDURE V20250414175127__Create_CreateActionReasonCSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='action_reason')) THEN 
CREATE TABLE `action_reason` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `actionReason` varchar(128) NOT NULL,
  `actionReasonFor` varchar(45) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actionReason_UNIQUE` (`actionReason`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `action_reason_ibfk_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'action_reason','ACTION_REASON','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'actionReason', 'ACTION_REASON', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 1, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
insert into standard_master_items (id,`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `emunType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`)
values(@ItemsMaxId+1,'actionReasonFor','ACTION_REASON_FOR',@standardMasterMaxId+1,'Enum','reason_type','2',false,b'0',b'0',false,1);

END IF;

END $$
CALL V20250414175127__Create_CreateActionReasonCSM () $$ 
DROP PROCEDURE IF EXISTS V20250414175127__Create_CreateActionReasonCSM $$ 
DELIMITER ;
