DELIMITER $$
DROP PROCEDURE IF EXISTS V20250421124804__Update_HEQF_Level_CSM $$
CREATE PROCEDURE V20250421124804__Update_HEQF_Level_CSM()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM standard_master sm where sm.tableName = 'heqf_level')) THEN 
SET @standardMasterMaxId=(SELECT MAX(sm.id) FROM standard_master sm where sm.tableName = 'heqf_level' ); 

IF NOT EXISTS ((SELECT * FROM standard_master_items as smi where smi.dbFieldName = 'valueInSpanish' and smi.standardMasterId =  @standardMasterMaxId)) THEN 
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'valueInSpanish', 'ITEM_VALUE_IN_SPANISH', @standardMasterMaxId, 'varchar', '3', 0, 0, 0, 1, '1', SYSDATE());
END IF; 

IF NOT EXISTS ((SELECT * FROM standard_master_items as smi where smi.dbFieldName = 'valueInFrench' and smi.standardMasterId =  @standardMasterMaxId)) THEN 
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'valueInFrench', 'ITEM_VALUE_IN_FRENCH', @standardMasterMaxId, 'varchar', '4', 0, 0, 0, 1, '1', SYSDATE());
END IF; 

    IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'ITEM_VALUE_IN_FRENCH')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('TRANSLATIONS', 'ITEM_VALUE_IN_FRENCH', 'Item Value in French', 'Item Value in French','Itemwaarde in Frans','Giá trị mục bằng tiếng Pháp',now(),1);
	END IF;
    
     IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'ITEM_VALUE_IN_SPANISH')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('TRANSLATIONS', 'ITEM_VALUE_IN_SPANISH', 'Item Value in Spanish', 'Item Value in Spanish','Itemwaarde in Spaans','Giá trị mặt hàng bằng tiếng Tây Ban Nha',now(),1);
	END IF;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250421124804__Update_HEQF_Level_CSM () $$
DROP PROCEDURE IF EXISTS V20250421124804__Update_HEQF_Level_CSM $$
DELIMITER ;