DELIMITER $$

DROP PROCEDURE IF EXISTS sageInvoices $$

CREATE PROCEDURE sageInvoices(
    IN lastUpdate DATETIME, 
    IN invoiceType TEXT, 
    IN invoiceStatus TEXT,
    IN docType TEXT
)
BEGIN
    IF docType = 'NOT_CANCEL_INVOICE_CREDITNOTE' THEN
        SELECT 
            'NUMERO_FACTURE' AS billNo, 
            'DATE_FACTURE' AS billingDate, 
            'MATRICULE_ETUDIANT' AS studentId, 
            'PRENOM' AS firstName, 
            'NOM' AS lastName, 
            'FILIERE' AS programName, 
            'SEMESTRE_CONCERNE' AS period, 
            'LIBELLE_FACTURE' AS feeHeads, 
            'MONTANT' AS invoiceAmount,
			'STATUT' as cancelStatus,
			'RAISON DE L''ANNULATION' as cancelNarration
        UNION ALL
        SELECT 
            bill.billNo AS billNo, 
            bill.billingDate AS billingDate, 
            u.code AS studentId, 
            u.firstName AS firstName, 
            u.lastName AS lastName, 
            p.programName AS programName, 
            period.programPeriodName AS period, 
            GROUP_CONCAT(feehead.feeHeadName) AS feeHeads, 
            bill.totalAmount AS invoiceAmount,
			'' as cancelStatus,
			bill.cancellationNarration as cancelNarration
        FROM bill_header bill
        INNER JOIN bill_fee_plan_rule_stage billstage ON bill.id = billstage.billId
        INNER JOIN fee_stage_head_config feestage ON billstage.feeStageHeadConfigId = feestage.id
        INNER JOIN fee_heads feehead ON feestage.feeHeadId = feehead.id
        INNER JOIN users u ON bill.studentId = u.id
        LEFT JOIN prog_batch_period_config period ON bill.programBatchPeriodConfigId = period.id
        LEFT JOIN batches b ON period.programBatchId = b.id
        LEFT JOIN programs p ON b.programId = p.id
        LEFT JOIN academic_term aterm ON period.academicTermId = aterm.id 
            AND aterm.whetherCurrentAcademicTerm = true
        WHERE 
            bill.raiseBillCategory = invoiceType 
            AND bill.creationDateTime > lastUpdate
            AND bill.billStatus != invoiceStatus 
        GROUP BY bill.id;
    
    ELSE
        SELECT 
            'NUMERO_FACTURE' AS billNo, 
            'DATE_FACTURE' AS billingDate, 
            'MATRICULE_ETUDIANT' AS studentId, 
            'PRENOM' AS firstName, 
            'NOM' AS lastName, 
            'FILIERE' AS programName, 
            'SEMESTRE_CONCERNE' AS period, 
            'LIBELLE_FACTURE' AS feeHeads, 
            'MONTANT' AS invoiceAmount,
			'STATUT' as cancelStatus,
			'RAISON DE L''ANNULATION' as cancelNarration
        UNION ALL
        SELECT 
            bill.billNo AS billNo, 
            bill.billingDate AS billingDate, 
            u.code AS studentId, 
            u.firstName AS firstName, 
            u.lastName AS lastName, 
            p.programName AS programName, 
            period.programPeriodName AS period, 
            GROUP_CONCAT(feehead.feeHeadName) AS feeHeads, 
            bill.totalAmount AS invoiceAmount,
			'Cancelled' as cancelStatus,
			bill.cancellationNarration as cancelNarration
        FROM bill_header bill
        INNER JOIN bill_fee_plan_rule_stage billstage ON bill.id = billstage.billId
        INNER JOIN fee_stage_head_config feestage ON billstage.feeStageHeadConfigId = feestage.id
        INNER JOIN fee_heads feehead ON feestage.feeHeadId = feehead.id
        INNER JOIN users u ON bill.studentId = u.id
        LEFT JOIN prog_batch_period_config period ON bill.programBatchPeriodConfigId = period.id
        LEFT JOIN batches b ON period.programBatchId = b.id
        LEFT JOIN programs p ON b.programId = p.id
        LEFT JOIN academic_term aterm ON period.academicTermId = aterm.id 
            AND aterm.whetherCurrentAcademicTerm = true
        WHERE 
            bill.raiseBillCategory = invoiceType 
            AND bill.cancellationDate > lastUpdate
            AND bill.billStatus = invoiceStatus 
        GROUP BY bill.id;
    END IF;

END $$

DELIMITER ;
