DELIMITER $$

DROP PROCEDURE IF EXISTS sp_get_applicant_relationship_details $$

CREATE PROCEDURE sp_get_applicant_relationship_details(IN in_applicant_person_id BIGINT)
BEGIN
    SELECT
        apr.relationship AS relationship,
        s.salutationName AS salutation_name,
        ap.firstName AS first_name,
        ap.middleName AS middle_name,
        ap.lastName AS last_name,
        ap.printName AS print_name,
        ap.emailId AS email_id,
        ap.mobileCountryCode AS mobile_country_code,
        ap.mobileNumber AS mobile_number,
        ap.alternateMobileCountryCode AS alternate_mobile_country_code,
        ap.alternateMobileNo AS alternate_mobile_number,
        idt.idTypeName AS id_type_name,
        ap.nationalID AS national_id,
        ap.isAlumnus AS is_alumnus,
        cs.itemValue AS campaign_school_value,
        apr.whetherDeleted AS is_deleted
    FROM applicant_person_relationships apr
    LEFT JOIN applicant_person ap ON apr.relatedApplicantPersonId = ap.id
    LEFT JOIN id_type idt ON ap.idTypeId = idt.id
    LEFT JOIN campaign_school cs ON ap.campaign_school_id = cs.id
    LEFT JOIN salutations s ON ap.salutationId = s.id
    WHERE apr.applicantPersonId = in_applicant_person_id;
END $$

DELIMITER ;
