DELIMITER $$
DROP PROCEDURE IF EXISTS V20250509121906__Alter_AddCityPincodeInAPDC $$
CREATE PROCEDURE V20250509121906__Alter_AddCityPincodeInAPDC()
BEGIN

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.COLUMNS 
    WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'address_detail_to_be_changed' 
      AND COLUMN_NAME = 'cityPinCodeId'
) THEN
    ALTER TABLE address_detail_to_be_changed
    ADD COLUMN cityPinCodeId BIGINT DEFAULT NULL;
END IF;

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.referential_constraints 
    WHERE constraint_schema = DATABASE() 
      AND TABLE_NAME = 'address_detail_to_be_changed' 
      AND CONSTRAINT_NAME = 'FK_APDC_city_pincode'
) THEN
    ALTER TABLE address_detail_to_be_changed
    ADD CONSTRAINT FK_APDC_city_pincode FOREIGN KEY (cityPinCodeId) REFERENCES city_pincode(id);
END IF;

END $$
CALL V20250509121906__Alter_AddCityPincodeInAPDC() $$
DROP PROCEDURE IF EXISTS V20250509121906__Alter_AddCityPincodeInAPDC $$
DELIMITER ;