DELIMITER $$

DROP PROCEDURE IF EXISTS V20250512124737__Insert_StudentPortalSubMenuAng $$

CREATE PROCEDURE V20250512124737__Insert_StudentPortalSubMenuAng()
BEGIN

    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE table_schema = DATABASE() 
          AND TABLE_NAME = 'student_portal_sub_menu_config' 
          AND COLUMN_NAME = 'moduleCode'
    ) THEN

        SET @myProfileId = (
            SELECT MAX(id) 
            FROM student_portal_menu_config 
            WHERE moduleCode = 'My_Profile'
        );

        IF NOT EXISTS (
            SELECT 1 
            FROM student_portal_sub_menu_config 
            WHERE moduleCode = 'Document'
        ) THEN
            INSERT IGNORE INTO student_portal_sub_menu_config
                (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy)
            VALUES
                (@myProfileId, 'Document', 'Document', b'1', 1, 1);
        END IF;

        IF NOT EXISTS (
            SELECT 1 
            FROM student_portal_sub_menu_config 
            WHERE moduleCode = 'Education'
        ) THEN
            INSERT IGNORE INTO student_portal_sub_menu_config
                (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy)
            VALUES
                (@myProfileId, 'Education', 'Education', b'1', 2, 1);
        END IF;

        SET @academicsId = (
            SELECT MAX(id) 
            FROM student_portal_menu_config 
            WHERE moduleCode = 'Academics'
        );

        IF NOT EXISTS (
            SELECT 1 
            FROM student_portal_sub_menu_config 
            WHERE moduleCode = 'Courses'
        ) THEN
            INSERT IGNORE INTO student_portal_sub_menu_config
                (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy)
            VALUES
                (@academicsId, 'Courses', 'Courses', b'1', 1, 1);
        END IF;

        IF NOT EXISTS (
            SELECT 1 
            FROM student_portal_sub_menu_config 
            WHERE moduleCode = 'Detailed Schedule'
        ) THEN
            INSERT IGNORE INTO student_portal_sub_menu_config
                (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy)
            VALUES
                (@academicsId, 'Detailed Schedule', 'Detailed Schedule', b'1', 2, 1);
        END IF;

        IF NOT EXISTS (
            SELECT 1 
            FROM student_portal_sub_menu_config 
            WHERE moduleCode = 'Homework Assignments'
        ) THEN
            INSERT IGNORE INTO student_portal_sub_menu_config
                (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy)
            VALUES
                (@academicsId, 'Homework Assignments', 'Homework Assignments', b'1', 3, 1);
        END IF;

        IF NOT EXISTS (
            SELECT 1 
            FROM student_portal_sub_menu_config 
            WHERE moduleCode = 'Attendance Report'
        ) THEN
            INSERT IGNORE INTO student_portal_sub_menu_config
                (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy)
            VALUES
                (@academicsId, 'Attendance Report', 'Attendance Report', b'1', 4, 1);
        END IF;

        SET @feesId = (
            SELECT MAX(id) 
            FROM student_portal_menu_config 
            WHERE moduleCode = 'Fees'
        );

        IF NOT EXISTS (
            SELECT 1 
            FROM student_portal_sub_menu_config 
            WHERE moduleCode = 'Bills'
        ) THEN
            INSERT IGNORE INTO student_portal_sub_menu_config
                (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy)
            VALUES
                (@feesId, 'Bills', 'Bills', b'1', 1, 1);
        END IF;

        IF NOT EXISTS (
            SELECT 1 
            FROM student_portal_sub_menu_config 
            WHERE moduleCode = 'Credit Note'
        ) THEN
            INSERT IGNORE INTO student_portal_sub_menu_config
                (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy)
            VALUES
                (@feesId, 'Credit Note', 'Credit Note', b'1', 2, 1);
        END IF;

        IF NOT EXISTS (
            SELECT 1 
            FROM student_portal_sub_menu_config 
            WHERE moduleCode = 'Receipt'
        ) THEN
            INSERT IGNORE INTO student_portal_sub_menu_config
                (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy)
            VALUES
                (@feesId, 'Receipt', 'Receipt', b'1', 3, 1);
        END IF;

        IF NOT EXISTS (
            SELECT 1 
            FROM student_portal_sub_menu_config 
            WHERE moduleCode = 'Payments'
        ) THEN
            INSERT IGNORE INTO student_portal_sub_menu_config
                (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy)
            VALUES
                (@feesId, 'Payments', 'Payments', b'1', 4, 1);
        END IF;

        IF NOT EXISTS (
            SELECT 1 
            FROM student_portal_sub_menu_config 
            WHERE moduleCode = 'Statement of account'
        ) THEN
            INSERT IGNORE INTO student_portal_sub_menu_config
                (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy)
            VALUES
                (@feesId, 'Statement of account', 'Statement of account', b'1', 5, 1);
        END IF;

        SET @requestId = (
            SELECT MAX(id) 
            FROM student_portal_menu_config 
            WHERE moduleCode = 'Request'
        );

        IF NOT EXISTS (
            SELECT 1 
            FROM student_portal_sub_menu_config 
            WHERE moduleCode = 'My Request'
        ) THEN
            INSERT IGNORE INTO student_portal_sub_menu_config
                (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy)
            VALUES
                (@requestId, 'My Request', 'My Request', b'1', 1, 1);
        END IF;

        SET @examinationId = (
            SELECT MAX(id) 
            FROM student_portal_menu_config 
            WHERE moduleCode = 'Examination'
        );

        IF NOT EXISTS (
            SELECT 1 
            FROM student_portal_sub_menu_config 
            WHERE moduleCode = 'My Examinations'
        ) THEN
            INSERT IGNORE INTO student_portal_sub_menu_config
                (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy)
            VALUES
                (@examinationId, 'My Examinations', 'My Examinations', b'1', 1, 1);
        END IF;

        IF NOT EXISTS (
            SELECT 1 
            FROM student_portal_sub_menu_config 
            WHERE moduleCode = 'Student Result Report'
        ) THEN
            INSERT IGNORE INTO student_portal_sub_menu_config
                (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy)
            VALUES
                (@examinationId, 'Student Result Report', 'Student Result Report', b'1', 2, 1);
        END IF;

    END IF;

END $$

CALL V20250512124737__Insert_StudentPortalSubMenuAng() $$

DROP PROCEDURE IF EXISTS V20250512124737__Insert_StudentPortalSubMenuAng $$

DELIMITER ;