DELIMITER $$
DROP PROCEDURE IF EXISTS V20250513120923__Create_PersonalDetailsInfoAngular $$
CREATE PROCEDURE V20250513120923__Create_PersonalDetailsInfoAngular()
BEGIN
-- Step 1: Create  table
 SET SQL_SAFE_UPDATES = 0;
 
 if not exists (SELECT 1 FROM form_field_info
  WHERE formScreenName IN ('Personal Details Info - Responsive', 'Fee Payer Details - Responsive','Education Details - Responsive')) then
  CREATE  TABLE form_field_info_responsive AS
  SELECT * FROM form_field_info
  WHERE formScreenName IN ('Personal Details Info', 'Fee Payer Details','Education Details');
  -- Step 2: Update formAliasName
  UPDATE form_field_info_responsive
  SET formAliasName = CONCAT(formAliasName, 'responsive');
  -- Step 3: Update formScreenName
  UPDATE form_field_info_responsive
  SET formScreenName = CONCAT(formScreenName, ' - Responsive');
  -- Step 4: Insert only non-duplicate rows
  INSERT INTO form_field_info (
  formAliasName,
  formFieldName,
  formFieldId,
  formFieldInputType,
  isMandatory,
  isLocked,
  defaultValue,
  lastUpdatedBy,
  formFieldDefaultLabel,
  formFieldDefaultHelpText,
  formScreenName,
  formScreenMode,
  fieldDisplayName,
  whetherForAllAcademyLocation
)
SELECT
  r.formAliasName,
  r.formFieldName,
  r.formFieldId,
  r.formFieldInputType,
  r.isMandatory,
  r.isLocked,
  r.defaultValue,
  r.lastUpdatedBy,
  r.formFieldDefaultLabel,
  r.formFieldDefaultHelpText,
  r.formScreenName,
  r.formScreenMode,
  r.fieldDisplayName,
  r.whetherForAllAcademyLocation
FROM form_field_info_responsive r
WHERE NOT EXISTS (
  SELECT 1
  FROM form_field_info f
  WHERE f.formAliasName = r.formAliasName
    AND f.formFieldName = r.formFieldName
    AND f.formFieldId = r.formFieldId
);
  -- Step 5: Drop temp table (optional since TEMPORARY)
  DROP TABLE IF EXISTS form_field_info_responsive;
SET SQL_SAFE_UPDATES = 1; 

end if;
END $$
CALL V20250513120923__Create_PersonalDetailsInfoAngular () $$ 
DROP PROCEDURE IF EXISTS V20250513120923__Create_PersonalDetailsInfoAngular $$ 
DELIMITER ;