DELIMITER $$
DROP PROCEDURE IF EXISTS V20250514175551__Update_ProgramPeriodDataGrid $$
CREATE PROCEDURE V20250514175551__Update_ProgramPeriodDataGrid()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM data_grid WHERE gridName="Academia.view.program.programDetails.programBatchDetails.periods.ProgramPeriodsGrid" AND portalId=1)) THEN 
UPDATE data_grid SET jsonObject ='[
    {
        "id": null,
        "columnName": "PROGRAM_BATCH_PERIOD_NAME",
        "dataIndex": "programPeriodName",
        "columnVisibility": "SHOW",
        "sequence": 1,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "PROGRAM_SEQUENCE",
        "dataIndex": "programPeriodSeq",
        "columnVisibility": "SHOW",
        "sequence": 2,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "ACADEMIC_TERM",
        "dataIndex": "academicTerm",
        "columnVisibility": "HIDE",
        "sequence": 3,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "OPTIONAL_PERIOD",
        "dataIndex": "whetherOptionalPeriod",
        "columnVisibility": "HIDE",
        "sequence": 4,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "PERIOD_START",
        "dataIndex": "programPeriodStartDate",
        "columnVisibility": "SHOW",
        "sequence": 5,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "PERIOD_END",
        "dataIndex": "programPeriodEndDate",
        "columnVisibility": "SHOW",
        "sequence": 6,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "MINIMUM_COURSES",
        "dataIndex": "minCourses",
        "columnVisibility": "SHOW",
        "sequence": 7,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "MAXIMUM_COURSES",
        "dataIndex": "maxCourses",
        "columnVisibility": "SHOW",
        "sequence": 8,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "MINIMUM_CREDITS",
        "dataIndex": "minCredits",
        "columnVisibility": "HIDE",
        "sequence": 9,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "MAXIMUM_CREDITS",
        "dataIndex": "maxCredit",
        "columnVisibility": "HIDE",
        "sequence": 10,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "SET_DEADLINE_ENROLLMENT",
        "dataIndex": "enrollmentLastDate",
        "columnVisibility": "HIDE",
        "sequence": 11,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "REGISTRATION_SETUP_NAME",
        "dataIndex": "registrationSetupName",
        "columnVisibility": "HIDE",
        "sequence": 12,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "CURRENT_PERIOD_OF_PROGRAM",
        "dataIndex": "isCurrentPeriodOfProgram",
        "columnVisibility": "HIDE",
        "sequence": 13,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "PERIOD_YEAR",
        "dataIndex": "periodYear",
        "columnVisibility": "SHOW",
        "sequence": 14,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "IS_LAST_PERIOD",
        "dataIndex": "isLastPeriodOfProgram",
        "columnVisibility": "HIDE",
        "sequence": 15,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "CAMPUS",
        "dataIndex": "campus",
        "columnVisibility": "HIDE",
        "sequence": 16,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "COMPUTER_USER_AREA",
        "dataIndex": "computerUserAreaValue",
        "columnVisibility": "HIDE",
        "sequence": 17,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "ATTESTATION_LINE_ONE",
        "dataIndex": "attestationLineOne",
        "columnVisibility": "HIDE",
        "sequence": 18,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "ATTESTATION_LINE_TWO",
        "dataIndex": "attestationLineTwo",
        "columnVisibility": "HIDE",
        "sequence": 19,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "PRINT_NAME_IN_FRENCH",
        "dataIndex": "printNameInFrench",
        "columnVisibility": "HIDE",
        "sequence": 20,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    },
    {
        "id": null,
        "columnName": "PRINT_NAME_IN_SPANISH",
        "dataIndex": "printNameInSpanish",
        "columnVisibility": "HIDE",
        "sequence": 21,
        "mandatory": false,
        "defaultSortBy": null,
        "orderBy": ""
    }
]' WHERE gridName='Academia.view.program.programDetails.programBatchDetails.periods.ProgramPeriodsGrid' and portalId=1;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250514175551__Update_ProgramPeriodDataGrid () $$
DROP PROCEDURE IF EXISTS V20250514175551__Update_ProgramPeriodDataGrid $$
DELIMITER ;