DELIMITER $$
DROP PROCEDURE IF EXISTS sageReceipts $$
CREATE PROCEDURE sageReceipts( IN lastUpdate DATETIME, IN receiptStatus TEXT)
BEGIN
    IF receiptStatus = 'CANCELLED' THEN
		SELECT 'NUMERO RECU PAIEMENT' receiptNo,
		'DATE PAIEMENT' receiptDate,
		'MATRICULE ETUDIANT' studentId,
		'PRENOM ET NOM' studentName,
		'FILIERE' programName,
		'SEMESTRE CONCERNE' period,
		'LIBELLE PAIEMENT' paymentMode,
		'MONTANT' amount,
		'STATUT' as cancelStatus,
		'RAISON DE L''ANNULATION' as cancelNarration
		UNION ALL
		select distinct receipt.receiptNo
		as receiptNo, receipt.transactionDate as receiptDate, u.code as studentId, u.firstName as studentName, p.programName as programName, period.programPeriodName as period,
		receipt.voucherMode as paymentMode, receipt.amount as amount,
		'Cancelled' as cancelStatus,
		receipt.cancellationNarration as cancelNarration
		from receipt_header receipt
		inner join billed_user_type utype on receipt.receiptFor = utype.id and upper(utype.billedUserType)='STUDENT'
		inner join students s on receipt.studentId = s.userId
		inner join users u on s.userId = u.id
		left join admission a on a.studentId = u.id and a.activeStatus=true
		left join program_batch_students pbs on pbs.admissionId = a.id and pbs.exitDate is null
		left join prog_batch_period_config period on pbs.progBatchPeriodConfigId = period.id
		left join academic_term caterm on caterm.whetherCurrentAcademicTerm = true
		left join academic_term faterm on period.academicTermId = faterm.id and faterm.sequence >=  caterm.sequence
		left join batches b on pbs.programBatchId = b.id
		left join programs p on b.programId = p.id
		where receipt.cancellationDate > lastUpdate
		and receipt.status = 'CANCELLED';
    ELSE
		SELECT 'NUMERO RECU PAIEMENT' receiptNo,
		'DATE PAIEMENT' receiptDate,
		'MATRICULE ETUDIANT' studentId,
		'PRENOM ET NOM' studentName,
		'FILIERE' programName,
		'SEMESTRE CONCERNE' period,
		'LIBELLE PAIEMENT' paymentMode,
		'MONTANT' amount,
		'STATUT' as cancelStatus,
		'RAISON DE L''ANNULATION' as cancelNarration
		UNION ALL
		select distinct receipt.receiptNo
		as receiptNo, receipt.transactionDate as receiptDate, u.code as studentId, u.firstName as studentName, p.programName as programName, period.programPeriodName as period,
		receipt.voucherMode as paymentMode, receipt.amount as amount,
		'Cancelled' as cancelStatus,
		receipt.cancellationNarration as cancelNarration
		from receipt_header receipt
		inner join billed_user_type utype on receipt.receiptFor = utype.id and upper(utype.billedUserType)='STUDENT'
		inner join students s on receipt.studentId = s.userId
		inner join users u on s.userId = u.id
		left join admission a on a.studentId = u.id and a.activeStatus=true
		left join program_batch_students pbs on pbs.admissionId = a.id and pbs.exitDate is null
		left join prog_batch_period_config period on pbs.progBatchPeriodConfigId = period.id
		left join academic_term caterm on caterm.whetherCurrentAcademicTerm = true
		left join academic_term faterm on period.academicTermId = faterm.id and faterm.sequence >=  caterm.sequence
		left join batches b on pbs.programBatchId = b.id
		left join programs p on b.programId = p.id
		where receipt.creationDateTime >lastUpdate
		and receipt.status != 'CANCELLED';
    END IF;
END $$
DELIMITER ;
