DELIMITER $$
DROP PROCEDURE IF EXISTS V20250521000738__Alter_AddColInReasonForProgramTransfer $$
CREATE PROCEDURE V20250521000738__Alter_AddColInReasonForProgramTransfer()
BEGIN

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.COLUMNS 
    WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'program_transfer_request_multiple_reason' 
      AND COLUMN_NAME = 'programTransferReasonCsmId'
) THEN
    ALTER TABLE program_transfer_request_multiple_reason
    ADD COLUMN programTransferReasonCsmId BIGINT DEFAULT NULL;
END IF;

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.referential_constraints 
    WHERE constraint_schema = DATABASE() 
      AND TABLE_NAME = 'program_transfer_request_multiple_reason' 
      AND CONSTRAINT_NAME = 'fk_reason_for_program_transfer'
) THEN
    ALTER TABLE program_transfer_request_multiple_reason
    ADD CONSTRAINT fk_reason_for_program_transfer FOREIGN KEY (programTransferReasonCsmId) REFERENCES reason_for_program_transfer(id);
END IF; 

INSERT IGNORE INTO reason_for_program_transfer (id, itemCode, itemValue, programTransferActive, lastUpdatedBy,lastUpdate)
select dd.id,name,value,b'1',1,now() from drop_down  dd
join program_transfer_request_multiple_reason AS ptrmr on ptrmr.programTransferReasonId=dd.id group by dd.id;

SET SQL_SAFE_UPDATES=0;
UPDATE program_transfer_request_multiple_reason AS ptrmr
JOIN program_transfer_request_multiple_reason AS ptrmrself
ON ptrmrself.programTransferRequestDetailId = ptrmr.programTransferRequestDetailId
SET ptrmr.programTransferReasonCsmId = ptrmrself.programTransferReasonId;
SET SQL_SAFE_UPDATES=1;


END $$
CALL V20250521000738__Alter_AddColInReasonForProgramTransfer() $$
DROP PROCEDURE IF EXISTS V20250521000738__Alter_AddColInReasonForProgramTransfer $$
DELIMITER ;