DELIMITER $$
DROP PROCEDURE IF EXISTS d2l5Offerings $$
CREATE PROCEDURE d2l5Offerings()
BEGIN
SELECT
'type', 'action', 'code', 'name', 'start_date', 'end_date', 'is_active', 'department_code', 'template_code', 'semester_code', 'offering_code', 'custom_code'
 UNION
SELECT
'Course Offering', 'UPDATE',  concat('CO', cv.id), cv.courseVariantDescription, DATE_FORMAT(period.programPeriodStart, '%Y-%m-%d'), DATE_FORMAT(period.programPeriodEnd, '%Y-%m-%d'), 
if(period.programPeriodEnd>= now(), 1,0),concat(al.academyCode,'-',al.locationCode), concat('CT', courses.id), concat('SM', period.id), '', concat('CT', courses.id)
from program_batch_course_param as param
join course_variants as cv on cv.id=param.courseVarientId
join academy_location as al on cv.academyLocationId= al.id
join courses on cv.courseId=courses.id
join prog_batch_period_config as period on param.progBatchPeriodConfigId= period.id
JOIN academic_term ON period.academicTermId=academic_term.id AND academic_term.whetherCurrentAcademicTerm=true
join batches on period.programBatchId=batches.id
join programs on batches.programId=programs.id;
END $$
DELIMITER ;