DELIMITER $$
DROP PROCEDURE IF EXISTS V20250527155024__Update_DeclineInterestEventRcpt $$
CREATE PROCEDURE V20250527155024__Update_DeclineInterestEventRcpt()
BEGIN
SET SQL_SAFE_UPDATES=0;
 IF EXISTS (SELECT id FROM dtprovider WHERE dataProviderName='DECLINED_COURSE_INTEREST_RCPNT') THEN
    SET @dtProviderId = (SELECT id FROM dtprovider WHERE dataProviderName='DECLINED_COURSE_INTEREST_RCPNT');

    UPDATE sql_dtprovider 
    SET sqlQuery = "select T1.id AS ID,
T13.firstName AS FIRST_NAME,
T13.lastName AS LAST_NAME,
T13.emailId AS EMAIL_ID,
T11.mobileNumber AS MOBILE_NO,
T13.code AS INITIATOR_CODE,
T13.printName AS INITIATOR_NAME,
T15.code AS EMPLOYEE_CODE,
T15.printName AS EMPLOYEE_NAME,
T4.courseCode AS COURSE_CODE,
T4.courseName AS COURSE_NAME,
T12.componentType AS COMPONENTS,
T6.courseCESMValue AS COURSE_CESM,
T7.itemValue AS PROGRAM_CESM
 from  faculty_course_interest_msg T1 
 join courses T4 on T4.id=T1.courseId
 join course_components T5 on T5.id=T1.courseComponentId
 join course_cesm_code T6 on T6.id=T1.courseCESMCodeId
 join program_cesm T7 on T7.id=T1.programCESMCodeId
 join faculty_course_interest T8 on T8.id=T1.facultyCourseInterestId
join users T9 on T9.id=T1.approverId

  join component_type T12 on T12.id=T5.componentTypeId
  left join users T13 on T13.id=T1.initiatorIdId
   Join staffs T10 on T10.userId=T13.id
  join persons T11 on T11.id=T10.personId
  left join staffs T14 on T14.userId=T8.userId
 left join users T15 on T15.id=T14.userId
where T9.emailId is not null and T1.id in (namedParams) limit 1"
    WHERE dataProviderId = @dtProviderId;
  END IF;
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250527155024__Update_DeclineInterestEventRcpt () $$
DROP PROCEDURE IF EXISTS V20250527155024__Update_DeclineInterestEventRcpt $$
DELIMITER ;