DELIMITER $$
DROP PROCEDURE IF EXISTS V20250625152018__Alter_ExamTransferCreditUpdate $$
CREATE PROCEDURE V20250625152018__Alter_ExamTransferCreditUpdate()
BEGIN

 IF EXISTS (
    SELECT * 
    FROM INFORMATION_SCHEMA.COLUMNS 
    WHERE TABLE_NAME = 'exam_transfer_credit' 
      AND table_schema=DATABASE()
      AND COLUMN_NAME = 'currentGrade'
  ) THEN
    ALTER TABLE exam_transfer_credit 
      CHANGE currentGrade marksGrade VARCHAR(30) DEFAULT NULL after examTransferType;
  END IF;

  -- Rename 'currentMarks' to 'gradePoint' if it exists
  IF EXISTS (
    SELECT * 
    FROM INFORMATION_SCHEMA.COLUMNS 
    WHERE TABLE_NAME = 'exam_transfer_credit' 
      AND table_schema=DATABASE()
      AND COLUMN_NAME = 'currentMarks'
  ) THEN
    ALTER TABLE exam_transfer_credit 
      CHANGE currentMarks gradePoint DOUBLE DEFAULT NULL after examTransferType;
  END IF;

  -- Add 'courseGradeType' if it doesn't already exist
  IF NOT EXISTS (
    SELECT * 
    FROM INFORMATION_SCHEMA.COLUMNS 
    WHERE TABLE_NAME = 'exam_transfer_credit'
      AND table_schema=DATABASE()
      AND COLUMN_NAME = 'courseGradeType'
  ) THEN
    ALTER TABLE exam_transfer_credit 
      ADD COLUMN courseGradeType VARCHAR(50) DEFAULT NULL after examTransferType;
  END IF;


END $$
CALL V20250625152018__Alter_ExamTransferCreditUpdate() $$
DROP PROCEDURE IF EXISTS V20250625152018__Alter_ExamTransferCreditUpdate $$
DELIMITER ;