DELIMITER $$
DROP PROCEDURE IF EXISTS getSAGEStudentsData $$
CREATE PROCEDURE `getSAGEStudentsData` (
    IN academyLocationId BIGINT,
    IN programCode varchar(25),
    IN batchCode varchar(25),
    IN admissionFromDate DATE,
    IN admissionToDate DATE,
    IN lastUpdatedFromDate DATE,
    IN lastUpdatedToDate DATE
)
BEGIN
    SELECT 
      	IFNULL(u.code, '') AS studentAccountNumber,
        IFNULL(u.printName, '') AS studentPrintName,
        IFNULL(sal.salutationName, '') AS salutation,
        TRIM(CONCAT_WS(' ', parentPer.firstName, parentPer.lastName)) AS parentName,
        IFNULL(per.mobileNumber, '') AS mobileNumber,
        IFNULL(parentPer.mobileNumber, '') AS parentMobile,
        IFNULL(b.printName, '') AS batchPrintName,
        IFNULL(phyAdd.addressText, '') AS physicalAddress,
        IFNULL(posAdd.addressText, '') AS postalAddress,
        IFNULL(p.programCode, '') AS programCode,
        IFNULL(sts.seatName, '') AS seatType
    FROM admission ad
    LEFT JOIN users u ON ad.studentId = u.id
    LEFT JOIN students st on u.id=st.userId
    LEFT JOIN persons per on st.personId=per.id
    LEFT JOIN academy_location al on ad.academyLocationId=al.id
    LEFT JOIN prog_batch_seat_config pbsc ON ad.programBatchSeatConfigId = pbsc.id
    LEFT JOIN batches b on pbsc.programBatchId=b.id
    LEFT JOIN programs p on b.programId=p.id
    LEFT JOIN seat_types sts on pbsc.seatTypeId=sts.id
    LEFT JOIN person_relationships rel ON rel.id = (SELECT pr.id FROM person_relationships pr WHERE pr.personId = per.id ORDER BY pr.id LIMIT 1)
    LEFT JOIN persons parentPer on rel.relatedPersonId=parentPer.id
    LEFT JOIN salutations sal on per.salutationId=sal.id
    LEFT JOIN person_addresses phyPad ON per.id = phyPad.personId AND phyPad.addressTypeId = '5'
    LEFT JOIN address phyAdd ON phyPad.addressId = phyAdd.id
    LEFT JOIN person_addresses posPad ON per.id = posPad.personId AND posPad.addressTypeId = '6'
    LEFT JOIN address posAdd ON posPad.addressId = posAdd.id
      WHERE (academyLocationId IS NULL OR al.id = academyLocationId)
      AND (programCode IS NULL OR p.programCode = programCode)
      AND (batchCode IS NULL OR b.batchName = batchCode)
      AND (admissionFromDate IS NULL OR DATE(ad.admissionDate) >= admissionFromDate)
      AND (admissionToDate IS NULL OR DATE(ad.admissionDate) <= admissionToDate)
      AND (lastUpdatedFromDate IS NULL OR DATE(ad.lastUpdate) >= lastUpdatedFromDate)
      AND (lastUpdatedToDate IS NULL OR DATE(ad.lastUpdate) <= lastUpdatedToDate)
    GROUP BY ad.id,u.id;
END$$
DELIMITER ;