DELIMITER $$
DROP PROCEDURE IF EXISTS V20250708104057__Insert_SponsorInvoiceDynamicIDgenrator $$
CREATE PROCEDURE V20250708104057__Insert_SponsorInvoiceDynamicIDgenrator()
BEGIN

SET SQL_SAFE_UPDATES = 0;
SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
/**Delete existing id generation configuration for sponsorInvoice*/
SET @IdSettingId=(SELECT id FROM id_entity_setting WHERE tableName='sponsor_invoice' and idGenerationTable="sponsor_invoice");
SET @IdDefinitionId=(SELECT id FROM id_definition WHERE idEntitySettingId =  @IdSettingId);

IF EXISTS ((SELECT * FROM id_format WHERE idDefinitionId  =  @IdDefinitionId )) THEN 
DELETE FROM `id_format_alphanumeric` WHERE id IN( SELECT id FROM id_format WHERE idDefinitionId  =  @IdDefinitionId );

DELETE FROM `id_format_dynamic` WHERE id IN( SELECT id FROM id_format WHERE idDefinitionId  =  @IdDefinitionId );

DELETE FROM `id_format_running_no` WHERE id IN( SELECT id FROM id_format WHERE idDefinitionId  =  @IdDefinitionId );

DELETE FROM `id_format` WHERE idDefinitionId =  @IdDefinitionId; 
END IF;

IF EXISTS ((select * from id_column_available where tableName="sponsor_invoice" and columnName="sponsorInvoiceNo")) THEN 
DELETE FROM  `id_column_available` WHERE  tableName="sponsor_invoice" and columnName="sponsorInvoiceNo" ;
END IF;

IF  EXISTS (select * from id_format_counter_mapping where idDefinition=@IdDefinitionId) THEN 
DELETE FROM `id_format_counter_mapping` WHERE  idDefinition=@IdDefinitionId;
END IF; 

IF  EXISTS ((select * from id_definition where idEntitySettingId=(select id from id_entity_setting where tableName="sponsor_invoice" and idGenerationTable="sponsor_invoice") and idColumn="sponsorInvoiceNo")) THEN 
DELETE FROM `id_definition` WHERE  idEntitySettingId=(select id from id_entity_setting where tableName="sponsor_invoice" and idGenerationTable="sponsor_invoice") and idColumn="sponsorInvoiceNo";
END IF; 

IF  EXISTS ((select * from id_entity_setting where tableName="sponsor_invoice" and idGenerationTable="sponsor_invoice")) THEN 
DELETE FROM `id_entity_setting`  WHERE tableName="sponsor_invoice" and idGenerationTable="sponsor_invoice" ;
END IF; 

/*inserting values for ID Generator*/
IF NOT EXISTS ((select * from id_column_available where tableName="sponsor_invoice" and columnName="sponsorInvoiceNo")) THEN 
INSERT INTO id_column_available (tableName, columnName) VALUES('sponsor_invoice','sponsorInvoiceNo');
END IF;

IF NOT EXISTS ((select * from id_entity_setting where tableName="sponsor_invoice" and idGenerationTable="sponsor_invoice")) THEN 
INSERT INTO id_entity_setting ( tableName, idGenerationTable,whetherFullyConfigurable,dynanicFieldAvailable, searchConfigCode, lastUpdatedBy, lastUpdate)
 VALUES('sponsor_invoice','sponsor_invoice',TRUE,TRUE,'IDG_SPONSOR_INVOICE',1,@currentTimeStamp);
SET @idEntitySettingId=(select id from id_entity_setting where tableName="sponsor_invoice" and idGenerationTable="sponsor_invoice");
END IF; 


IF NOT EXISTS ((select * from id_definition where idEntitySettingId=@idEntitySettingId and idColumn="sponsorInvoiceNo")) THEN 
INSERT  INTO id_definition(idEntitySettingId,idFormatType,idColumn,whetherManualId,whetherDefaultID,lastUpdatedBy,lastUpdate,VERSION)
 VALUES ( @idEntitySettingId,'ALPHA_NUMERIC','sponsorInvoiceNo',0,0,1,@currentTimeStamp,0);
END IF; 

SET @idDefinitionId=(select id from id_definition where idEntitySettingId=@idEntitySettingId and idColumn="sponsorInvoiceNo");
IF NOT EXISTS ((select * from id_format where idDefinitionId=@idDefinitionId)) THEN 
INSERT  INTO id_format(idDefinitionId,seqNo,lastUpdatedBy,lastUpdate) VALUES (@idDefinitionId,1,1,@currentTimeStamp);
SET @idFormat=(select id from id_format where idDefinitionId=@idDefinitionId);
END IF;

SET SQL_SAFE_UPDATES = 1;
END $$
CALL V20250708104057__Insert_SponsorInvoiceDynamicIDgenrator() $$
DROP PROCEDURE IF EXISTS V20250708104057__Insert_SponsorInvoiceDynamicIDgenrator $$
DELIMITER ;