DELIMITER $$
DROP PROCEDURE IF EXISTS V20250804141025__Insert_studentPortalSubMenuVac $$
CREATE PROCEDURE V20250804141025__Insert_studentPortalSubMenuVac()
BEGIN

DECLARE menuId INT;

    SET SQL_SAFE_UPDATES = 0;

    -- Truncate Tables
    IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = DATABASE() AND TABLE_NAME = 'student_portal_sub_menu_config') THEN 
        SET FOREIGN_KEY_CHECKS = 0;
        TRUNCATE TABLE student_portal_sub_menu_config;
        SET FOREIGN_KEY_CHECKS = 1;
    END IF;
    IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = DATABASE() AND TABLE_NAME = 'student_portal_menu_config') THEN 
        SET FOREIGN_KEY_CHECKS = 0;
        TRUNCATE TABLE student_portal_menu_config;
        SET FOREIGN_KEY_CHECKS = 1;
    END IF;

    SET SQL_SAFE_UPDATES = 1;

    -- Insert into student_portal_menu_config
    INSERT INTO student_portal_menu_config (moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy) VALUES
    ('DASHBOARD', 'Dashboard', b'1', 1, 1),
    ('MY_PROFILE', 'My Profile', b'1', 2, 1),
    ('REGISTRATION', 'Registration', b'1', 3, 1),
    ('ACADEMICS', 'Academics', b'1', 4, 1),
    ('FEES', 'Fees', b'1', 5, 1),
    ('REQUEST', 'Request', b'1', 6, 1),
    ('SERVICES_&_COMMUNITIES', 'Services & Communities', b'1', 7, 1),
    ('EXAMINATION', 'Examination', b'1', 8, 1),
    ('ACADEMIA_DRIVE', 'Academia Drive', b'1', 9, 1);

    -- My Profile
    SELECT id INTO menuId FROM student_portal_menu_config WHERE moduleCode = 'MY_PROFILE';
    INSERT INTO student_portal_sub_menu_config (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy) VALUES
    (menuId, 'DOCUMENT', 'Document', b'1', 1, 1),
    (menuId, 'STUDENT_SIBLING', 'Student Sibling', b'1', 2, 1),
    (menuId, 'STUDENT_DISCIPLINARY_ACTIONS', 'Student Disciplinary Actions', b'1', 3, 1),
    (menuId, 'STUDENT_MEDICAL', 'Student Medical', b'1', 4, 1),
    (menuId, 'STUDENT_INCIDENTS', 'Student Incidents', b'1', 5, 1),
    (menuId, 'STUDENT_WORK_EXPERIENCE', 'Student Work Experience', b'1', 6, 1),
    (menuId, 'STUDENT_MEDICAL_DETAIL', 'Student Medical Detail', b'1', 7, 1),
    (menuId, 'TRAINING_DETAILS', 'Training Details', b'1', 8, 1),
    (menuId, 'EDUCATION', 'Education', b'1', 9, 1),
    (menuId, 'EDUCATION_DETAILS', 'Education Details', b'1', 10, 1),
    (menuId, 'HOLDS', 'Holds', b'1', 11, 1),
    (menuId, 'SEMINAR_DETAILS', 'Seminar Details', b'1', 12, 1),
    (menuId, 'COMPETITIVE_EXAM', 'Competitive Exam', b'1', 13, 1),
    (menuId, 'POST_SCHOOL_STUDIES', 'Post School Studies', b'1', 14, 1),
    (menuId, 'STUDENT_JOURNEY', 'Student Journey', b'1', 15, 1),
    (menuId, 'LIVING_ARRANGEMENT', 'Living Arrangement', b'1', 16, 1),
    (menuId, 'COMMUNICATION_HISTORY', 'Communication History', b'1', 17, 1),
	(menuId, 'STUDENT_VACCINATION', 'Student Vaccination', b'1', 18, 1);
    -- Academics
    SELECT id INTO menuId FROM student_portal_menu_config WHERE moduleCode = 'ACADEMICS';
    INSERT INTO student_portal_sub_menu_config (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy) VALUES
    (menuId, 'COURSE', 'Course', b'1', 1, 1),
    (menuId, 'HOMEWORK_ASSIGNMENTS', 'Homework Assignments', b'1', 2, 1),
    (menuId, 'DETAILED_SCHEDULE', 'Detailed Schedule', b'1', 3, 1),
    (menuId, 'SESSION_REPORT', 'Session Report', b'1', 4, 1),
    (menuId, 'SPECIALIZATION_ENROLLMENT', 'Specialization Enrollment', b'1', 5, 1),
    (menuId, 'DEGREE_AUDIT_REPORT', 'Degree Audit Report', b'1', 6, 1),
    (menuId, 'COURSE_GROUP_REPORT', 'Course Group Report', b'1', 7, 1),
    (menuId, 'ACADEMIC_TOPICS', 'Academic Topics', b'1', 8, 1),
    (menuId, 'ATTENDANCE_REPORT', 'Attendance Report', b'1', 9, 1),
    (menuId, 'CONDITIONS_FOR_ADMISSION', 'Conditions for Admission', b'1', 10, 1),
    (menuId, 'GRADUATION_CEREMONY', 'Graduation Ceremony', b'1', 11, 1);

    -- Fees
    SELECT id INTO menuId FROM student_portal_menu_config WHERE moduleCode = 'FEES';
    INSERT INTO student_portal_sub_menu_config (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy) VALUES
	(menuId, 'BILLS', 'Bills', b'1', 1, 1),
    (menuId, 'CREDIT_NOTE', 'Credit Note', b'1', 2, 1),
    (menuId, 'RECEIPT', 'Receipt', b'1', 3, 1),
    (menuId, 'PAYMENTS', 'Payments', b'1', 4, 1),
    (menuId, 'STUDENT_ONLINE_PAYMENTS', 'Student Online Payments', b'1', 5, 1),
    (menuId, 'STUDENT_OFFLINE_PAYMENT_DETAILS', 'Student Offline Payment Details', b'1', 6, 1),
	(menuId, 'STATEMENT_OF_ACCOUNT', 'Statement of Account', b'1', 7, 1),
    (menuId, 'SCHOLARSHIPS', 'Scholarships', b'1', 8, 1),
    (menuId, 'PAYMENT_PLAN', 'Payment Plan', b'1', 9, 1);

    -- Request
    SELECT id INTO menuId FROM student_portal_menu_config WHERE moduleCode = 'REQUEST';
    INSERT INTO student_portal_sub_menu_config (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy) VALUES
	(menuId, 'ALL_REQUEST', 'All Request', b'1', 1, 1),
    (menuId, 'RAISE_GRIEVANCE', 'Raise Grievance', b'1', 2, 1);

    -- Services & Communities
    SELECT id INTO menuId FROM student_portal_menu_config WHERE moduleCode = 'SERVICES_&_COMMUNITIES';
    INSERT INTO student_portal_sub_menu_config (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy) VALUES
    (menuId, 'LEAVE_REPORT', 'Leave Report', b'1', 1, 1),
    (menuId, 'SERVICES', 'Services', b'1', 2, 1),
    (menuId, 'COMMUNITY', 'Community', b'1', 3, 1),
    (menuId, 'MY_COMMITTEES', 'My Committees', b'1', 4, 1),
    (menuId, 'HOSTEL_PERSONAL_REQUIREMENTS', 'Hostel Personal Requirements', b'1', 5, 1),
    (menuId, 'HOSTEL_DETAILS', 'Hostel Details', b'1', 6, 1),
    (menuId, 'MY_SCHEDULED_EVENTS', 'My Scheduled Events', b'1', 7, 1),
    (menuId, 'TRANSPORT_DETAILS', 'Transport Details', b'1', 8, 1),
    (menuId, 'APPLY_FOR_COMMITTEE', 'Apply For Committee', b'1', 9, 1);

    -- Examination
    SELECT id INTO menuId FROM student_portal_menu_config WHERE moduleCode = 'EXAMINATION';
    INSERT INTO student_portal_sub_menu_config (studentPortalMenuConfigurationId, moduleCode, moduleName, isVisiable, sequence, lastUpdatedBy) VALUES
    (menuId, 'MY_EXAMINATION', 'My Examination', b'1', 1, 1),
    (menuId, 'EXAM_DOCUMENTS', 'Exam Documents', b'1', 2, 1),
    (menuId, 'EXAM_TIMETABLE', 'Exam Timetable', b'1', 3, 1),
    (menuId, 'EXAMINATIONS_CENTER', 'Examinations Center', b'1', 4, 1),
    (menuId, 'THESIS_MANAGEMENT', 'Thesis Management', b'1', 5, 1),
    (menuId, 'EXAMINATION_RESULTS', 'Examination Results', b'1', 6, 1),
    (menuId, 'MARK_ENTRY_REPORT', 'Mark Entry Report', b'1', 7, 1),
    (menuId, 'STUDENT_RESULT_REPORT', 'Student Result Report', b'1', 8, 1),
    (menuId, 'APPLY_FOR_REVALUATION', 'Apply For Revaluation', b'1', 9, 1),
    (menuId, 'EXAMINATION_TIMETABLE', 'Examination Timetable', b'1', 10, 1),
    (menuId, 'STUDENT_ASSESSMENT_REPORT', 'Student Assessment Report', b'1', 11, 1); 

END $$
CALL V20250804141025__Insert_studentPortalSubMenuVac() $$
DROP PROCEDURE IF EXISTS V20250804141025__Insert_studentPortalSubMenuVac $$
DELIMITER ;