DELIMITER $$
DROP PROCEDURE IF EXISTS V20250820110540__Update_PeriodDetailsListDataProvider $$
CREATE PROCEDURE V20250820110540__Update_PeriodDetailsListDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS (SELECT id FROM  dydt_data_provider where providerName = 'Inactive Admission Data Providers') THEN
SET @dydtdatalinitemId=(SELECT MAX(id) FROM dydt_data_line_item);
SET @dydtdataproviderId = (SELECT dataProviderId FROM dydt_data_line_item where dataSourceCode='INACTIVE_ADMISSION_DATA_PROVIDERS');
IF EXISTS (SELECT * FROM dydt_data_line_item WHERE dataProviderId = @dydtdataproviderId AND id = @dydtdatalinitemId) THEN
UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT 
    pbpc.id AS periodConfigId,
    pbpc.printName AS periodName,
    CASE
        WHEN EXISTS (
            SELECT 1
            FROM program_batch_students pbs
            WHERE pbs.admissionId = sce.admissionId
              AND pbs.isCurrentPeriod = TRUE
              AND pbs.isCurrentSection = TRUE
              AND pbs.isPeriodCompleted = FALSE
              AND pbs.exitDate IS NULL
              AND pbpc.id = pbs.progBatchPeriodConfigId
        ) THEN 1
        ELSE 0
    END AS isCurrentPeriod,
    c.courseName,
    FLOOR(c.courseCredits) AS courseCredits,
    COALESCE(lp.topics, 0) AS teachingHours,
    COALESCE(lp.term, 0) AS learningHours
FROM student_course_enrollment sce
INNER JOIN prog_batch_period_config pbpc 
    ON sce.programBatchPeriodConfigId = pbpc.id
INNER JOIN admission adm 
    ON adm.id = sce.admissionId
INNER JOIN course_variants cv 
    ON cv.id = sce.courseVarientId
LEFT JOIN courses c 
    ON c.id = cv.courseId
LEFT JOIN lesson_plan lp 
    ON lp.courseId = cv.courseId 
   AND pbpc.academicTermId = lp.academicTermId' , `sqlWhereQueryDef` = 'WHERE adm.id = PRM_ADMISSION_ID AND sce.exitDate IS NULL ORDER BY pbpc.id, c.courseName' ,
    `whetherMultiRecord` = 1 WHERE `dataProviderId`=@dydtdataproviderId AND `id` =  @dydtdatalinitemId;
END IF;
END IF;
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250820110540__Update_PeriodDetailsListDataProvider () $$
DROP PROCEDURE IF EXISTS V20250820110540__Update_PeriodDetailsListDataProvider $$
DELIMITER ;