DELIMITER $$

DROP PROCEDURE IF EXISTS V20250821150743__Alter_alter_msg_category $$

CREATE PROCEDURE V20250821150743__Alter_alter_msg_category()
BEGIN
    -- Check if the 'code' column exists in the 'msg_category' table
    IF EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_schema = DATABASE()
          AND table_name = 'msg_category'
          AND column_name = 'code'
    ) THEN
        -- If the column exists, alter the table
        ALTER TABLE msg_category MODIFY code VARCHAR(255);
    END IF;
END $$

-- Call the procedure
CALL V20250821150743__Alter_alter_msg_category() $$

-- Drop the procedure after execution
DROP PROCEDURE IF EXISTS V20250821150743__Alter_alter_msg_category $$

DELIMITER ;
