DELIMITER $$
DROP PROCEDURE IF EXISTS V20250901122545__Update_general_survey_csm $$
CREATE PROCEDURE V20250901122545__Update_general_survey_csm()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM standard_master WHERE tableName ='general_survey_csm')) THEN  
SET @standardMasterId=(SELECT id FROM standard_master  WHERE tableName ='general_survey_csm');
UPDATE `standard_master` SET `masterName` = 'QUICK_POLL' WHERE `id` = @standardMasterId;

IF EXISTS ((SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'SURVEY_NAME')) THEN
SET @ItemId=(SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'SURVEY_NAME');
UPDATE  `standard_master_items` SET `fieldLabel` = 'POLL_NAME', `diaplayOrder` = '2' WHERE `id` = @ItemId;
END IF; 
 
 IF EXISTS ((SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'SURVEY_KEY')) THEN
SET @ItemId=(SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'SURVEY_KEY');
UPDATE  `standard_master_items` SET `fieldLabel` = 'POLL_KEY', `diaplayOrder` = '3' WHERE `id` = @ItemId;
 END IF;
 
 IF EXISTS ((SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'SURVEY_URL')) THEN
SET @ItemId=(SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'SURVEY_URL');
UPDATE  `standard_master_items` SET `fieldLabel` = 'POLL_URL', `diaplayOrder` = '4' WHERE `id` = @ItemId;
 END IF;
 
 IF EXISTS ((SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'SURVEY_TOKEN')) THEN
SET @ItemId=(SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'SURVEY_TOKEN');
UPDATE  `standard_master_items` SET `fieldLabel` = 'POLL_TOKEN' , `diaplayOrder` = '5' WHERE `id` = @ItemId;
 END IF;
 
 IF EXISTS ((SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'IS_ADMIN_PORTAL')) THEN
SET @ItemId=(SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'IS_ADMIN_PORTAL');
UPDATE  `standard_master_items` SET `diaplayOrder` = '6' WHERE `id` = @ItemId;
END IF;
 
 IF EXISTS ((SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'IS_FACULTY_PORTAL')) THEN
SET @ItemId=(SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'IS_FACULTY_PORTAL');
UPDATE  `standard_master_items` SET `diaplayOrder` = '7' WHERE `id` = @ItemId;
END IF; 
 
 IF EXISTS ((SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'IS_STUDENT_PORTAL')) THEN
SET @ItemId=(SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'IS_STUDENT_PORTAL');
UPDATE  `standard_master_items` SET `diaplayOrder` = '8' WHERE `id` = @ItemId;
END IF; 
 
 IF EXISTS ((SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'IS_PARENT_PORTAL')) THEN
SET @ItemId=(SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'IS_PARENT_PORTAL');
UPDATE  `standard_master_items` SET `diaplayOrder` = '9' WHERE `id` = @ItemId;
  END IF;
 
 IF NOT EXISTS ((SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'ACADEMY_LOCATION')) THEN
 INSERT INTO  standard_master_items (`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
 VALUES ('academyLocation', 'ACADEMY_LOCATION', @standardMasterId, 'multiselectcombofield', '1',  0 ,  0,  0, '1' , now());
 END IF;
 
 IF NOT EXISTS ((SELECT id FROM standard_master_items where standardMasterId = @standardMasterId and fieldLabel= 'IS_APPLICANT_PORTAL')) THEN
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES ('isApplicant', 'IS_APPLICANT_PORTAL', @standardMasterId, 'Boolean', '10', 0, 0, 0, 0, '1', now());
END IF;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250901122545__Update_general_survey_csm () $$
DROP PROCEDURE IF EXISTS V20250901122545__Update_general_survey_csm $$
DELIMITER ;