DELIMITER $$
DROP PROCEDURE IF EXISTS V20250909192122__Update_extExamTransferDataGridEnhanced $$
CREATE PROCEDURE V20250909192122__Update_extExamTransferDataGridEnhanced()
BEGIN
    SET SQL_SAFE_UPDATES=0;
    IF EXISTS (
        SELECT * 
        FROM data_grid 
        WHERE gridName = 'Academia.view.student.studentprofile.StudentExternalTransferCreditRequestGrid' 
          AND portalId = 1
    ) THEN 
        UPDATE data_grid
        SET jsonObject = '[
            {"id":null,"columnName":"PERIOD","dataIndex":"programPeriodName","columnVisibility":"SHOW","sequence":1,"mandatory":false},
            {"id":null,"columnName":"COURSE_CODE","dataIndex":"courseCode","columnVisibility":"SHOW","sequence":2,"mandatory":false}, 
            {"id":null,"columnName":"COURSE_NAME","dataIndex":"courseName","columnVisibility":"SHOW","sequence":3,"mandatory":false},
            {"id":null,"columnName":"CREDITS","dataIndex":"courseCredit","columnVisibility":"SHOW","sequence":4,"mandatory":false},
            {"id":null,"columnName":"MARKS_OR_GRADE","dataIndex":"marksGrade","columnVisibility":"HIDE","sequence":5,"mandatory":false},
            {"id":null,"columnName":"EQUIVALENT_COURSE_CODE","dataIndex":"equivalentCourseCode","columnVisibility":"HIDE","sequence":6,"mandatory":false},
            {"id":null,"columnName":"EQUIVALENT_COURSE_NAME","dataIndex":"equivalentCourseName","columnVisibility":"HIDE","sequence":7,"mandatory":false},
            {"id":null,"columnName":"OBTAINED_MARKS_GRADES","dataIndex":"obtainedMarksGrade","columnVisibility":"HIDE","sequence":8,"mandatory":false},
            {"id":null,"columnName":"INSTITUTE_NAME","dataIndex":"institueName","columnVisibility":"HIDE","sequence":9,"mandatory":false},
            {"id":null,"columnName":"EQUIVALENT_COURSE_CREDIT","dataIndex":"equivalentCourseCredit","columnVisibility":"HIDE","sequence":10,"mandatory":false},
            {"id":null,"columnName":"STATUS","dataIndex":"applicantTransferCreditStatus","columnVisibility":"SHOW","sequence":11,"mandatory":false},
            {"id":null,"columnName":"STUDENT_REMARK","dataIndex":"studentRemark","columnVisibility":"SHOW","sequence":12,"mandatory":false},
            {"id":null,"columnName":"FACULTY_REMARK","dataIndex":"facultyRemark","columnVisibility":"SHOW","sequence":13,"mandatory":false},
            {"id":null,"columnName":"FACULTY_APPROVER_DATE","dataIndex":"facultyApproverDate","columnVisibility":"HIDE","sequence":14,"mandatory":false},
            {"id":null,"columnName":"FACULTY_APPROVER_NAME","dataIndex":"facultyApproverName","columnVisibility":"HIDE","sequence":15,"mandatory":false},
            {"id":null,"columnName":"COMPLETION_DATE","dataIndex":"completionDate","columnVisibility":"HIDE","sequence":16,"mandatory":false},
            {"id":null,"columnName":"EQUIVALENT_COURSE_SYLLABUS","dataIndex":"document","columnVisibility":"HIDE","sequence":17,"mandatory":false}
        ]' 
        WHERE gridName = 'Academia.view.student.studentprofile.StudentExternalTransferCreditRequestGrid' 
          AND portalId = 1;
    END IF;
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250909192122__Update_extExamTransferDataGridEnhanced () $$
DROP PROCEDURE IF EXISTS V20250909192122__Update_extExamTransferDataGridEnhanced $$
DELIMITER ;