DELIMITER $$
DROP PROCEDURE IF EXISTS V20250922124311__Update_NotificationForGraduationEvent $$
CREATE PROCEDURE V20250922124311__Update_NotificationForGraduationEvent()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT MAX(id) FROM dtprovider WHERE `dataProviderName`='NOTIFICATION_FOR_GRADUATION_RCPNT')) THEN 
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider WHERE `dataProviderName`='NOTIFICATION_FOR_GRADUATION_RCPNT');
update sql_dtprovider set sqlQuery="select DISTINCT 
    T1.id As ID ,
    T3.code AS STUDENT_ID,
    p.printName AS STUDENT_PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.middleName AS MIDDLE_NAME,
    p.lastName AS LAST_NAME,
    p.mobileNumber AS MOBILE_NO,
    p.emailId AS EMAIL_ID,
    T9.programNameToBePrint AS STUDENT_ADMITTED_PROGRAM_NAME,
    T9.programCode AS STUDENT_ADMITTED_PROGRAM_CODE,
    T10.printName AS STUDENT_BATCH,
    T12.printName AS STUDENT_GRADUATED_PERIOD_NAME,
    T13.itemValue AS STUDENT_GRADUATED_ACADEMIC_TERM, 
    T15.websiteURL AS ACADEMY_LOCATION_WEBSITE_URL,
    (CASE
        WHEN
            T5.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.headerUrl)
        ELSE NULL
    END) AS HEADER_IMAGE_URL,
    (CASE
        WHEN
            T5.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.footerUrl)
        ELSE NULL
    END) AS FOOTER_IMAGE_URL,
    T5.academyName AS ACADEMY_NAME,
    T5.locationName AS LOCATION_NAME,
    T5.displayName AS ACADEMY_LOCATION_DISPLAY_NAME,
    T8.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T8.phoneCountryCode AS ACADEMY_LOCATION_PHONE_CODE,
    T8.phoneAreaCode AS ACADEMY_LOCATION_PHONE_AREA_CODE,
    T8.phoneNo AS ACADEMY_LOCATION_PHONE_NO,
    T8.cellCountryCode AS ACADEMY_LOCATION_MOBILE_CODE,
    T8.cellNo AS ACADEMY_LOCATION_MOBILE_NO
 FROM completions T1
	LEFT JOIN
     students T2 ON T2.userId = T1.studentId
    LEFT JOIN  
    persons p on p.id = T2.personId
	LEFT JOIN
    users T3 ON T2.userId = T3.id
    LEFT JOIN
	admission T4 on T4.id = T1.admissionId
    LEFT JOIN
    academy_location T5 on T5.id = T4.academyLocationId
    LEFT JOIN 
    locations T6 on T6.id = T5.locationId
    LEFT JOIN 
    location_addresses T7 on T7.locationId = T6.id
    LEFT JOIN 
    address T8 on T8.id = T7.addressId
    LEFT JOIN
    programs T9 on T9.id = T1.programId
    LEFT JOIN 
    batches T10 on T10.id = T1.batchId
    LEFT JOIN 
    program_batch_students T11 on T11.id = T4.id
    LEFT JOIN 
    prog_batch_period_config T12 on T12.id = T11.progBatchPeriodConfigId
    LEFT JOIN 
    academic_term T13 on T13.id = T12.academicTermId
    LEFT JOIN    
    organizations org ON org.id = (SELECT MAX(id) FROM organizations)
    LEFT JOIN 
    organization_addresses T14 ON org.id=T14.organizationId
    LEFT JOIN 
    address T15 on T15.id = T14.addressId
    LEFT JOIN 
    address_type T16 ON T16.id=T8.addressTypeId
    where T1.id in (namedParams) and T15.addressTypeId=1"
 where dataProviderId=@dtproviderId ;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250922124311__Update_NotificationForGraduationEvent () $$
DROP PROCEDURE IF EXISTS V20250922124311__Update_NotificationForGraduationEvent $$
DELIMITER ;