DELIMITER $$
DROP PROCEDURE IF EXISTS V20251008173145__Create_PassoutLetterDynamicDocument $$
CREATE PROCEDURE V20251008173145__Create_PassoutLetterDynamicDocument()
BEGIN

IF NOT EXISTS ((SELECT * FROM dydt_document_type where typeName='Passout Letter' )) THEN 

-- Start :  setting of dynamic document

  SET @dydtdocumenttypeId=(SELECT MAX(id) FROM `dydt_document_type`);
  INSERT INTO `dydt_document_type` (`id`,`typeName`, `configLevelCode`, `whetherDeletable`, `typeCode`, `availableForAdhoc`, `whetherEditable`) 
  VALUES (@dydtdocumenttypeId+1,'Passout Letter', 'ACADEMY_LOCATION_LEVEL', '0', 'Passout Letter', '0', '1');

  SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='NOTIFICATION_FOR_GRADUATION');
  SET @msgtemplateconfigId =(SELECT id FROM msg_template_config where code='Notification For Graduation');
  SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='STUDENT_NOTIFICATION_FOR_GRADUATION');
  SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='NOTIFICATION_FOR_GRADUATION_RCPNT');
  SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

  SET  @sysMsgEvtDefaultConfId = (select MAX(id) from sys_msg_evt_default_conf where systemMsgEventId=@sysMsgEventId);
  SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf` where sysMsgEvtDefaultConfId=@sysMsgEvtDefaultConfId);
  SET @sysmsgevtrcpntdocId=(SELECT MAX(id) FROM `sys_msg_evt_rcpnt_doc`);
  SET @msgscopeparamId=(select id from msg_scope_param where paramKey='ACADEMY_LOCATION_IDS');

  INSERT INTO `sys_msg_evt_rcpnt_doc`(`id`,`sysMsgEvtRcpntDefaultConfigId`,`docTypeId`,`docGenOwnerMappingDef`,`docGenParamMapDef`)
  VALUES(@sysmsgevtrcpntdocId+1,@sysmsgevtrcptdefaultconfId,@dydtdocumenttypeId+1,@msgscopeparamId,'[{"MSG_PARAM":"CONTEXT_RECORD_ID","DOC_GEN_PARAM":"PRM_STUDENT_ID"}]');

  -- Start : Mapping of Dynamic Document to MsgTemplate

  SET @msgtemplateconfigdocId=(SELECT MAX(id) FROM `msg_template_config_doc`);
  INSERT INTO `msg_template_config_doc` (`id`,`msgTemplateconfigId`, `sysMsgEvtRcpntdocId`) VALUES (@msgtemplateconfigdocId+1,@msgtemplateconfigId,@sysmsgevtrcpntdocId+1);

  -- End : Mapping of Dynamic Document to Msgtemplate

  SET @dydtdataproviderId=(SELECT MAX(id) FROM `dydt_data_provider`);
  INSERT INTO `dydt_data_provider` (`id`,`providerName`, `priority`) VALUES (@dydtdataproviderId+1,'PROGRAM_GROUP_CATEGORY_DATA_PROVIDER_INFO', '1');

  SET @dydtdocumentdataproviderId=(SELECT MAX(id) FROM `dydt_document_data_provider`);
  INSERT INTO `dydt_document_data_provider` (`id`,`dataProviderId`, `documentTypeId`) VALUES (@dydtdocumentdataproviderId+1,@dydtdataproviderId+1, @dydtdocumenttypeId+1);

  SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
  INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, 
  `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) 
  VALUES (@dydtdatalinitemId+1, @dydtdataproviderId+1, 'PASSOUT_LETTER', '1',null,'1', '1', 
  'select DISTINCT comp.id As ID,
       usr.code AS STUDENT_ID,
       p.printName AS STUDENT_PRINT_NAME,
       p.firstName AS FIRST_NAME,
       p.middleName AS MIDDLE_NAME,
       p.lastName AS LAST_NAME,
       p.mobileNumber AS MOBILE_NO,
       p.emailId AS EMAIL_ID,
       pg.groupName as PROGRAM_GROUP,
       pc.categoryName as PROGRAM_CATEGORY
       from completions comp
	LEFT JOIN programs prog ON prog.id=comp.programId
	LEFT JOIN program_group pg on pg.id=prog.programGroupId
	LEFT JOIN program_category pc on pc.id=prog.programCategoryId
    LEFT JOIN  students std ON std.userId = comp.studentId
    LEFT JOIN  persons p on p.id = std.personId
    LEFT JOIN  users usr ON std.userId = usr.id','PRM_STUDENT_ID', 
       'PROGRAM_GROUP,PROGRAM_CATEGORY','where comp.id=PRM_STUDENT_ID', '0');


INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PROGRAM_GROUP', 'Program Group',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PROGRAM_CATEGORY', 'Program Category',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PROGRAM_GROUP_CATEGORY_DATA_PROVIDER_INFO', 'Program Group Category Data Provider Info',@dydtdatalinitemId+1);


END IF; 

END $$
CALL V20251008173145__Create_PassoutLetterDynamicDocument () $$ 
DROP PROCEDURE IF EXISTS V20251008173145__Create_PassoutLetterDynamicDocument $$ 
DELIMITER ;