DELIMITER $$  
DROP PROCEDURE IF EXISTS V20251009171042__Update_Student_Al_Transfer_Confermation   $$
CREATE PROCEDURE V20251009171042__Update_Student_Al_Transfer_Confermation()
BEGIN
    SET SQL_SAFE_UPDATES = 0;

    SET @sqlDtproviderId = (SELECT MAX(id) FROM `sql_dtprovider`);
    SET @dtproviderId = (SELECT id FROM dtprovider WHERE `dataProviderName` = 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT1_DL');
    IF EXISTS (SELECT * FROM `sql_dtprovider` WHERE `dataProviderId` = @dtproviderId) THEN 
        UPDATE `sql_dtprovider`
        SET `sqlQuery` = 'SELECT
                              T3.id AS USER_ID
                          FROM
                              users T1
                          LEFT JOIN students s ON T1.id = s.userId
                          LEFT JOIN person_relationships T2 ON T2.personId = s.personId
                          LEFT JOIN persons T3 ON T3.id = T2.relatedPersonId
                          WHERE
                              T1.id IN (namedParams)
                              AND T2.relationship = ''FATHER''',
            `jsonString` = NULL
        WHERE `dataProviderId` = @dtproviderId;
    END IF;

    SET @dtproviderId = (SELECT id FROM dtprovider WHERE `dataProviderName` = 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_DL');
    IF EXISTS (SELECT * FROM `sql_dtprovider` WHERE `dataProviderId` = @dtproviderId) THEN
        UPDATE `sql_dtprovider`
        SET `sqlQuery` = 'SELECT
                              T3.id AS USER_ID
                          FROM
                              users T1
                          LEFT JOIN students s ON T1.id = s.userId
                          LEFT JOIN person_relationships T2 ON T2.personId = s.personId
                          LEFT JOIN persons T3 ON T3.id = T2.relatedPersonId
                          WHERE
                              T1.id IN (namedParams)
                              AND T2.relationship = ''MOTHER''',
            `jsonString` = NULL
        WHERE `dataProviderId` = @dtproviderId;
    END IF;

    SET @dtproviderId = (SELECT id FROM dtprovider WHERE `dataProviderName` = 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_DL');
    IF EXISTS (SELECT * FROM `sql_dtprovider` WHERE `dataProviderId` = @dtproviderId) THEN
        UPDATE `sql_dtprovider`
        SET `sqlQuery` = 'SELECT
                              T2.id AS USER_ID
                          FROM
                              users T1
                          LEFT JOIN students T4 ON T4.userId = T1.id
                          LEFT JOIN persons T3 ON T3.id = T4.personId
                          LEFT JOIN fee_payer_detail T2 ON T2.personId = T3.id
                          WHERE
                              T1.id IN (namedParams) AND T2.isPrimaryFeePayer = true',
            `jsonString` = NULL
        WHERE `dataProviderId` = @dtproviderId;
    END IF;

    SET SQL_SAFE_UPDATES = 1;
END $$  
CALL V20251009171042__Update_Student_Al_Transfer_Confermation ()   $$
DROP PROCEDURE IF EXISTS V20251009171042__Update_Student_Al_Transfer_Confermation $$
DELIMITER ;