DELIMITER $$
DROP PROCEDURE IF EXISTS V20251028071851__Alter_AddColumnMRMasterNew $$
CREATE PROCEDURE V20251028071851__Alter_AddColumnMRMasterNew()
BEGIN

IF NOT EXISTS (
        SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'monthly_report_master_osm' 
          AND TABLE_SCHEMA = DATABASE() 
          AND COLUMN_NAME = 'keyHighLightsStatus'
    ) THEN
        ALTER TABLE monthly_report_master_osm
            ADD COLUMN keyHighLightsStatus BIT(1) DEFAULT b'1';
    END IF;

    IF NOT EXISTS (
        SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'monthly_report_master_osm' 
          AND TABLE_SCHEMA = DATABASE() 
          AND COLUMN_NAME = 'sequence'
    ) THEN
        ALTER TABLE monthly_report_master_osm
            ADD COLUMN sequence BIGINT NULL DEFAULT 0 ;
    END IF;

   IF NOT EXISTS (
        SELECT 1
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_NAME = 'monthly_report_master_osm'
          AND TABLE_SCHEMA = DATABASE()
          AND COLUMN_NAME = 'mRMParentId'
    ) THEN
        -- Add the column if it doesn't exist
        ALTER TABLE monthly_report_master_osm
            ADD COLUMN mRMParentId BIGINT NULL DEFAULT 0;
    END IF;

    -- check and add lastUpdatedBy
    IF NOT EXISTS (
        SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'monthly_report_master_osm' 
          AND TABLE_SCHEMA = DATABASE() 
          AND COLUMN_NAME = 'lastUpdatedBy'
    ) THEN
        ALTER TABLE monthly_report_master_osm
            ADD COLUMN lastUpdatedBy BIGINT NOT NULL ;
    END IF;

    -- check and add lastUpdate
    IF NOT EXISTS (
        SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'monthly_report_master_osm' 
          AND TABLE_SCHEMA = DATABASE() 
          AND COLUMN_NAME = 'lastUpdate'
    ) THEN
        ALTER TABLE monthly_report_master_osm
            ADD COLUMN lastUpdate TIMESTAMP NOT NULL
                DEFAULT CURRENT_TIMESTAMP
                ON UPDATE CURRENT_TIMESTAMP
            AFTER lastUpdatedBy;
    END IF;

END $$
CALL V20251028071851__Alter_AddColumnMRMasterNew() $$
DROP PROCEDURE IF EXISTS V20251028071851__Alter_AddColumnMRMasterNew $$
DELIMITER ;