DELIMITER $$
DROP PROCEDURE IF EXISTS V20251028144644__Create_Send_Payment_Link_Applicant $$
CREATE PROCEDURE V20251028144644__Create_Send_Payment_Link_Applicant()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='SEND_ONLINE_PAYMENT_LINK_APPLICANT')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='FEE_PAYMENT');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'SEND_ONLINE_PAYMENT_LINK_APPLICANT');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='SEND_ONLINE_PAYMENT_LINK_APPLICANT');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'SEND_ONLINE_PAYMENT_LINK_APPLICANT', 'Send Online Payment Link - Applicant', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Send Online Payment Link - Applicant');
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SEND_ONLINE_PAYMENT_LINK_APPLICANT_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SEND_ONLINE_PAYMENT_LINK_APPLICANT_RECIPIENT', 'SQL');
 
 -- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_ONLINE_PAYMENT_LINK_APPLICANT_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'SEND_ONLINE_PAYMENT_LINK_APPLICANT_RECIPIENT');
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_ONLINE_PAYMENT_LINK_APPLICANT_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SEND_ONLINE_PAYMENT_LINK_APPLICANT_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 -- Setting the query for the Applicant distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_ONLINE_PAYMENT_LINK_APPLICANT_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT DISTINCT T1.id AS USER_ID FROM payment_link T1 WHERE T1.id IN (namedParams)",NULL);
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_ONLINE_PAYMENT_LINK_APPLICANT_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT DISTINCT
    T1.id AS ID,
	T11.printName AS APPLICANT_PRINT_NAME,
    T11.firstName AS FIRST_NAME,
    T11.middleName AS MIDDLE_NAME,
	T11.lastName AS LAST_NAME,
	T1.totalOutstandingAmount AS AMOUNT,
    T1.encryptedlink AS PAYMENT_LINK,
    T10.currencyCode AS CURRENCY,
    T6.displayName AS CAMPUS_DISPLAY_NAME,
    T8.primaryeEmailId AS CAMPUS_CONTACT_EMAIL,
    T8.phoneNo AS CAMPUS_CONTACT_PHONE,
    T8.cellNo AS CAMPUS_CONTACT_NUMBER,
    T8.websiteURL AS CAMPUS_WEBSITE,
    T13.printName AS PARENT1,
    T15.printName AS PARENT2,
    T11.mobileNumber as MOBILE_NO,
    T11.emailId AS EMAIL_ID
FROM
    payment_link T1
		LEFT OUTER JOIN 
    application T2 ON T2.id = T1.applicantId 
		LEFT OUTER JOIN	
	payment_link_bills T3 ON T3.paymentLinkId = T1.id   
        LEFT OUTER JOIN
    bill_header T4 ON T4.id = T3.billHeaderId    
        LEFT OUTER JOIN 
	academy_location T6 ON T4.academyLocationId = T6.id
        LEFT OUTER JOIN 
	academy_location_addresses T7 ON T7.academyLocationId = T6.id
        LEFT OUTER JOIN 
	address T8 ON T8.id = T7.addressId
	    LEFT OUTER JOIN 
    address_type T9 ON T9.id = T8.addressTypeId
       LEFT OUTER JOIN 
	currency T10 ON T10.id = T4.currencyId
	   LEFT OUTER JOIN 
    applicant_person T11 ON T11.id = T2.applicantPersonId
       LEFT OUTER JOIN
	applicant_person_relationships T12 ON T12.applicantPersonId = T11.id and T12.relationship='FATHER'
	   LEFT OUTER JOIN
    applicant_person T13 ON T13.id = T12.relatedApplicantPersonId
	  LEFT OUTER JOIN
	applicant_person_relationships T14 ON T14.applicantPersonId = T11.id and T14.relationship='MOTHER'
      LEFT OUTER JOIN 
    applicant_person T15 ON T15.id = T14.relatedApplicantPersonId  
WHERE
     T9.code='CRNT' and T9.addressCategory='ACDLOC' and 
    T1.id IN (namedParams)",'{
     "id": 1,
     "searchResultViewColumns": [        
        {
            "id": 1,
            "value": "code",
            "resultKey": "PAYMENT_LINK",
            "displayCode": "",
            "displayOrder": 0
        },
         {
            "id": 2,
            "value": "printName",
            "resultKey": "PARENT1",
            "displayCode": "",
            "displayOrder": 1
        },
         {
            "id": 3,
            "value": "printName",
            "resultKey": "PARENT2",
            "displayCode": "",
            "displayOrder": 2
        },              
        {
            "id": 4,
            "value": "printName",
            "resultKey": "APPLICANT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "displayName",
            "resultKey": "CAMPUS_DISPLAY_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "primaryeEmailId",
            "resultKey": "CAMPUS_CONTACT_EMAIL",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "phoneNo",
            "resultKey": "CAMPUS_CONTACT_PHONE",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "cellNo",
            "resultKey": "CAMPUS_CONTACT_NUMBER",
            "displayCode": "",
            "displayOrder": 7
        },{
            "id": 9,
            "value": "websiteURL",
            "resultKey": "CAMPUS_WEBSITE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "currencyCode",
            "resultKey": "CURRENCY",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "totalOutstandingAmount",
            "resultKey": "AMOUNT",
            "displayCode": "",
            "displayOrder": 10
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='SEND_ONLINE_PAYMENT_LINK_APPLICANT_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='SEND_ONLINE_PAYMENT_LINK_APPLICANT');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='SEND_ONLINE_PAYMENT_LINK_APPLICANT');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SEND_ONLINE_PAYMENT_LINK_APPLICANT_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Send Online Payment Link - Applicant',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Send Online Payment Link - Applicant',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'2','','');
 
 --  INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 -- VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'4','','');
 
 -- INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 -- VALUES (@msgtemplateId+4,@msgtemplateconfigId+1,'6','','');

END IF;



IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='SEND_ONLINE_PAYMENT_LINK_APPLICANT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'SEND_ONLINE_PAYMENT_LINK_APPLICANT', 'Send Online Payment Link - Applicant', 'Send Online Payment Link - Applicant', 'Stuur aanlynbetalingskakel - Applicant', 'Gửi Link Thanh Toán Trực Tuyến - Sinh Viên',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='SEND_ONLINE_PAYMENT_LINK_APPLICANT_DL')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'SEND_ONLINE_PAYMENT_LINK_APPLICANT_DL', 'Send Online Payment Link - Applicant DL', 'Send Online Payment Link - Applicant DL', 'Stuur aanlynbetalingskakel - Applicant DL', 'Gửi Link Thanh Toán Trực Tuyến - DL Sinh Viên',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='SEND_ONLINE_PAYMENT_LINK_APPLICANT_RECIPIENT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'SEND_ONLINE_PAYMENT_LINK_APPLICANT_RECIPIENT', 'Send Online Payment Link - Applicant Recipient', 'Send Online Payment Link - Applicant Recipient', 'Stuur aanlynbetalingskakel - Applicante-ontvanger', 'Gửi link thanh toán trực tuyến - Sinh viên nhận',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='SEND_ONLINE_PAYMENT_LINK_APPLICANT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('SEND_ONLINE_PAYMENT_LINK_APPLICANT', 'Send Online Payment Link - Applicant');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='SEND_ONLINE_PAYMENT_LINK_APPLICANT_DL')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('SEND_ONLINE_PAYMENT_LINK_APPLICANT_DL', 'Send Online Payment Link - Applicant DL');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='SEND_ONLINE_PAYMENT_LINK_APPLICANT_RECIPIENT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('SEND_ONLINE_PAYMENT_LINK_APPLICANT_RECIPIENT', 'Send Online Payment Link - Applicant Recipient');
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='APPLICANT_PRINT_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'APPLICANT_PRINT_NAME', 'Applicant Name', 'Applicant Name', 'Applicante naam', 'Tên học sinh',now(),1);
END IF;


END $$
CALL V20251028144644__Create_Send_Payment_Link_Applicant () $$ 
DROP PROCEDURE IF EXISTS V20251028144644__Create_Send_Payment_Link_Applicant $$ 
DELIMITER ;