DELIMITER $$
DROP PROCEDURE IF EXISTS V20251105134626__Update_AppFeeHeadInfoOfferLetterDate $$
CREATE PROCEDURE V20251105134626__Update_AppFeeHeadInfoOfferLetterDate()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from `dydt_data_line_item` where `dataSourceCode` = 'OFFER_LETTER_EXPIRY_DATE')) THEN 
SET @dydtDataLineItemId = (select id from `dydt_data_line_item` where `dataSourceCode` = 'OFFER_LETTER_EXPIRY_DATE');
UPDATE `dydt_data_line_item` 
SET `sqlSelectQueryDef`=
"SELECT 
    pp.offerLetterExpiryDate AS offer_letter_expiry_date,
    DATE_FORMAT(apd.expiryDate, '%e %b %Y') AS offer_exp_date,
    DATE_FORMAT(pp.admissionOfferStartDate, '%e %b %Y') AS offer_letter_start_date,
    pp.offerLetterAcceptDaysLimit AS offer_letter_accept_day_limit,
    DATE_FORMAT(ap.offerLetterIssueDate, '%e %b %Y') AS offer_letter_issue_date,
    IFNULL(
        DATE_FORMAT(
            CASE 
                WHEN pp.offerLetterAcceptDaysLimit IS NULL 
                     OR pp.offerLetterAcceptDaysLimit = 0 
                THEN pp.offerLetterExpiryDate
                WHEN apd.expiryDate IS NULL 
                THEN pp.offerLetterExpiryDate
                ELSE LEAST(
                    apd.expiryDate,
                    DATE_ADD(ap.offerLetterIssueDate, INTERVAL pp.offerLetterAcceptDaysLimit DAY)
                )
            END,
            '%e %b %Y'
        ),
        ''
    ) AS calculated_expire_date
FROM prog_slctn_process_admisn_conf AS pp
JOIN program_selection_process AS psp 
    ON pp.programSelectionProcessId = psp.id
JOIN application_program AS ap 
    ON ap.progBatchSeatConfigId = psp.programBatchSeatConfigId
LEFT JOIN application_program_detail AS apd 
    ON apd.applicationProgramId = ap.id", 
`resultColumnsDef`='offer_exp_date,offer_letter_start_date,offer_letter_end_date, calculated_expire_date'
WHERE `id` = @dydtDataLineItemId;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251105134626__Update_AppFeeHeadInfoOfferLetterDate () $$
DROP PROCEDURE IF EXISTS V20251105134626__Update_AppFeeHeadInfoOfferLetterDate $$
DELIMITER ;