DELIMITER $$
DROP PROCEDURE IF EXISTS V20251208144539__Insert_EmailDeferredResit $$
CREATE PROCEDURE V20251208144539__Insert_EmailDeferredResit()
BEGIN
IF NOT EXISTS ((select id from system_msg_event where code='EMAIL_MARKSHEET_FOR_DEFERRED_RESIT_STATUS')) THEN 

SET @parentcategoryId=(select MAX(id) from msg_category where code="EXAMINATION");
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'EMAIL_MARKSHEET_FOR_DEFERRED_RESIT_STATUS');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT MAX(id) FROM msg_category WHERE `code`='EMAIL_MARKSHEET_FOR_DEFERRED_RESIT_STATUS');

INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'EMAIL_MARKSHEET_FOR_DEFERRED_RESIT_STATUS', 'Email Marksheet For Deferred Resit Status', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Email Marksheet For Deferred Resit Status');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT MAX(id) FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT MAX(id) FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT MAX(id) FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT MAX(id) FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT MAX(id) FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'EMAIL_MARKSHEET_FOR_DEFERRED_RESIT_STATUS_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'EMAIL_MARKSHEET_FOR_DEFERRED_RESIT_STATUS_RECIPIENT', 'SQL');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider WHERE `dataProviderName`='EMAIL_MARKSHEET_FOR_DEFERRED_RESIT_STATUS_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'EMAIL_MARKSHEET_FOR_DEFERRED_RESIT_STATUS_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider WHERE `dataProviderName`='EMAIL_MARKSHEET_FOR_DEFERRED_RESIT_STATUS_DL');
SET @recipientTypeId=(SELECT MAX(id) FROM `msg_recipient_type` WHERE `code`='EMAIL_MARKSHEET_FOR_DEFERRED_RESIT_STATUS_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider WHERE `dataProviderName`='EMAIL_MARKSHEET_FOR_DEFERRED_RESIT_STATUS_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT T1.id AS USER_ID 
      FROM progression_panel_exam_event T1 
      WHERE T1.id IN (namedParams);",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider WHERE `dataProviderName`='EMAIL_MARKSHEET_FOR_DEFERRED_RESIT_STATUS_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
" SELECT 
         examEvent.id AS ID,
         person.firstName AS FIRST_NAME,
         person.printName AS STUDENT_PRINT_NAME,
         person.lastName AS LAST_NAME,
         person.emailId AS EMAIL_ID,
         user.code AS STUDENT_ID,
         program.programNameToBePrint AS PROGRAM_NAME,
         batch.printName AS BATCH_NAME,
         period.printName AS PERIOD_NAME,
         location.academyName AS ACADEMY_NAME,
         location.locationName AS LOCATION_NAME,
         prStatus.itemCode AS PROGRESSION_STATUS,
         committee.progressionPanelStartDate AS PRINT_DATETIME,
         marksheetJob.id AS JOB_ID,
         panel.remarks AS REMARK,
         'userGeneratedMsgContent' AS USER_GENERATED_MSG_CONTENT

      FROM
         progression_panel_exam_event examEvent
         INNER JOIN progression_panel_decision_template panel ON panel.id = examEvent.progressionPanelDecisionId
         INNER JOIN progression_status prStatus ON panel.decisionId = prStatus.id
         INNER JOIN marksheet_job_details marksheetJob ON marksheetJob.id = examEvent.marksheetJobId
         INNER JOIN admission adm ON adm.id = panel.admissionId AND adm.studentId = panel.studentId
         INNER JOIN users user ON user.id = adm.studentId
         INNER JOIN students student ON student.userId = user.id
         INNER JOIN persons person ON person.id = student.personId
         INNER JOIN academy_location location ON location.id = adm.academyLocationId
         INNER JOIN prog_batch_period_config period ON period.id = panel.periodId
         INNER JOIN batches batch ON batch.id = period.programBatchId
         INNER JOIN programs program ON program.id = batch.programId
         INNER JOIN committee committee ON committee.id = panel.committeeId
      WHERE
         examEvent.id IN (namedParams)
      LIMIT 1",'{
     "id": 1,
     "searchResultViewColumns": [
	  {
             "id": 1,
             "value": "code",
             "resultKey": "STUDENT_ID",
             "displayCode": "",
             "displayOrder": 0
	   },
        {
             "id": 2,
             "value": "printName",
             "resultKey": "STUDENT_PRINT_NAME",
             "displayCode": "",
             "displayOrder": 1
	   },
 	    {
            "id": 3,
             "value": "programName",
             "resultKey": "PROGRAM_NAME",
             "displayCode": "",
             "displayOrder": 2
 	    },
 	    {
            "id": 4,
             "value": "batchName",
             "resultKey": "BATCH_NAME",
             "displayCode": "",
             "displayOrder": 3
 	   },
       {
            "id": 5,
             "value": "programPeriodName",
             "resultKey": "PERIOD_NAME",
             "displayCode": "",
             "displayOrder": 4
 	   },
       {
             "id": 6,
             "value": "academyName",
             "resultKey": "ACADEMY_NAME",
             "displayCode": "",
             "displayOrder": 5
		},
		{
             "id": 7,
             "value": "locationName",
             "resultKey": "LOCATION_NAME",
             "displayCode": "",
             "displayOrder": 6
         },
         {
             "id": 8,
             "value": "programExamStatus",
             "resultKey": "PROGRESSION_STATUS",
             "displayCode": "",
             "displayOrder": 7
         },
         {
             "id": 9,
             "value": "progressionPanelStartDate",
             "resultKey": "PRINT_DATETIME",
             "displayCode": "",
             "displayOrder": 8
         },
      {
             "id": 10,
             "value": "remarks",
             "resultKey": "REMARK",
             "displayCode": "",
             "displayOrder": 9
         }
          
 ]}');

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT MAX(id) FROM system_msg_event where code='EMAIL_MARKSHEET_FOR_DEFERRED_RESIT_STATUS');


SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT MAX(id) FROM `msg_category` WHERE `code`='EMAIL_MARKSHEET_FOR_DEFERRED_RESIT_STATUS');
SET @recipientTypeId=(SELECT MAX(id) FROM `msg_recipient_type` WHERE `code`='EMAIL_MARKSHEET_FOR_DEFERRED_RESIT_STATUS_RECIPIENT');
SET @msgMessageTypeId=(SELECT MAX(id) FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Email Marksheet For Deferred Resit Status Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Email Marksheet For Deferred Resit Status Template',NULL,'',NULL,'','APPROVED','','1','System Admin','1','English',b'1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Your Academic Results',
'<!DOCTYPE html>
<html lang="en">
<head>
<p style="text-align:right"> $recipientData[&quot;PRINT_DATETIME&quot;]</p>
 <tr>
	<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="https://www.serosoft.com/mailer/sommet/sommet_signature6.png" /></td>
 </tr>
</head>
<body>
    <div>
     <p><b><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Progression Panel Results- $recipientData[&quot;STUDENT_PRINT_NAME&quot;] ($recipientData[&quot;STUDENT_ID&quot;]) $recipientData[&quot;BATCH_NAME&quot;] $recipientData[&quot;PROGRAM_NAME&quot;]</span></b></p>
        <p>Dear Student,</p>
        <p>The Progression Panel has reviewed your overall performance.</p>
        <p>Your results indicate that you have successfully completed the semester. Congratulations! It represents the accumulation of a great deal of hard work and effort. We hope that your future studies will be equally successful.</p>
        <p>You will receive a transcript of your grades from the Student Registry Services.</p>
        <p>Please check the academic rules and regulations <a href="https://gihe.app.box.com/v/RulesandRegulations">here</a> before contacting us.</p>
        <p>Once you have read the academic rules and regulations and should you have any further questions regarding:</p>
            <p>- Your individual grades: please contact your Faculty members</p>
           <p>- Your academic progression: please contact your Program Team <a href="https://gihe.app.box.com/v/RulesandRegulations">Undergraduate Program Team</a> directly</p>
        </ul>
        <p>Best regards,</p>
        <p>Progression Panel</p>
    </div>
</body>
</html>

');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'4','Your Academic Results',
'<!DOCTYPE html>
<html lang="en">
<head>
<p style="text-align:right"> $recipientData[&quot;PRINT_DATETIME&quot;]</p>
 <tr>
	<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="https://www.serosoft.com/mailer/sommet/sommet_signature6.png" /></td>
 </tr>
</head>
<body>
    <div>
     <p><b><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Progression Panel Results- $recipientData[&quot;STUDENT_PRINT_NAME&quot;] ($recipientData[&quot;STUDENT_ID&quot;]) $recipientData[&quot;BATCH_NAME&quot;] $recipientData[&quot;PROGRAM_NAME&quot;]</span></b></p>
        <p>Dear Student,</p>
        <p>The Progression Panel has reviewed your overall performance.</p>
        <p>Your results indicate that you have successfully completed the semester. Congratulations! It represents the accumulation of a great deal of hard work and effort. We hope that your future studies will be equally successful.</p>
        <p>You will receive a transcript of your grades from the Student Registry Services.</p>
        <p>Please check the academic rules and regulations <a href="https://gihe.app.box.com/v/RulesandRegulations">here</a> before contacting us.</p>
        <p>Once you have read the academic rules and regulations and should you have any further questions regarding:</p>
            <p>- Your individual grades: please contact your Faculty members</p>
           <p>- Your academic progression: please contact your Program Team <a href="https://gihe.app.box.com/v/RulesandRegulations">Undergraduate Program Team</a> directly</p>
        </ul>
        <p>Best regards,</p>
        <p>Progression Panel</p>
    </div>
</body>
</html>
');
END IF;

END $$
CALL V20251208144539__Insert_EmailDeferredResit() $$
DROP PROCEDURE IF EXISTS V20251208144539__Insert_EmailDeferredResit $$
DELIMITER ;