DELIMITER $$
DROP PROCEDURE IF EXISTS V20251208152942__Insert_EmailDeferredTrans $$
CREATE PROCEDURE V20251208152942__Insert_EmailDeferredTrans()
BEGIN

IF NOT EXISTS (
    SELECT * FROM `ui_translation` 
    WHERE objectName = 'MESSAGING_TRANSLATIONS' 
      AND keyName = 'EMAIL_MARKSHEET_FOR_DEFERRED_STATUS'
) THEN
INSERT INTO `ui_translation` (
    `objectName`, `keyName`, `defaultValue`, `customerDefineValue`, 
    `russLanguage`, `frenLanguage`, `afriLanguage`, `vietLanguage`, `spanLanguage`, 
    `lastUpdate`, `lastUpdatedBy`
)
VALUES (
    'MESSAGING_TRANSLATIONS', 'EMAIL_MARKSHEET_FOR_DEFERRED_STATUS',
    'Email Marksheet For Deferred Status', 'Email Marksheet For Deferred Status',
    NULL, NULL, 'E-pos Merkblad Vir Uitgestelde Status', 'Bảng điểm qua email cho tình trạng hoãn lại', NULL,
    NOW(), 1
);
END IF;


IF NOT EXISTS (
    SELECT * FROM `picklist_translation` 
    WHERE `key` = 'EMAIL_MARKSHEET_FOR_DEFERRED_STATUS'
) THEN
INSERT INTO `picklist_translation` (`key`, `en`)
VALUES ('EMAIL_MARKSHEET_FOR_DEFERRED_STATUS', 'Email Marksheet For Deferred Status');
END IF;

IF NOT EXISTS (
    SELECT * FROM `ui_translation` 
    WHERE objectName = 'MESSAGING_TRANSLATIONS' 
      AND keyName = 'EMAIL_MARKSHEET_FOR_DEFERRED_STATUS_RECIPIENT'
) THEN
INSERT INTO `ui_translation` (
    `objectName`, `keyName`, `defaultValue`, `customerDefineValue`, 
    `russLanguage`, `frenLanguage`, `afriLanguage`, `vietLanguage`, `spanLanguage`, 
    `lastUpdate`, `lastUpdatedBy`
)
VALUES (
    'MESSAGING_TRANSLATIONS', 'EMAIL_MARKSHEET_FOR_DEFERRED_STATUS_RECIPIENT',
    'Email Marksheet For Deferred Status Recipient', 'Email Marksheet For Deferred Status Recipient',
    NULL, NULL, 'E-pos Merkblad Vir Uitgestelde Status Ontvanger', 'Bảng điểm qua email cho người nhận có tình trạng hoãn lại', NULL,
    NOW(), 1
);
END IF;


IF NOT EXISTS (
    SELECT * FROM `picklist_translation` 
    WHERE `key` = 'EMAIL_MARKSHEET_FOR_DEFERRED_STATUS_RECIPIENT'
) THEN
INSERT INTO `picklist_translation` (`key`, `en`)
VALUES ('EMAIL_MARKSHEET_FOR_DEFERRED_STATUS_RECIPIENT', 'Email Marksheet For Deferred Retake Status Recipient');
END IF;


END $$
CALL V20251208152942__Insert_EmailDeferredTrans() $$
DROP PROCEDURE IF EXISTS V20251208152942__Insert_EmailDeferredTrans $$
DELIMITER ;