DELIMITER $$
DROP PROCEDURE IF EXISTS V20251209112049__Insert_studentDocumentFeePayerEvent $$
CREATE PROCEDURE V20251209112049__Insert_studentDocumentFeePayerEvent()
BEGIN

SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='STUDENT' limit 1);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'FEE_PAYER_DOCUMENT');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event );
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='FEE_PAYER_DOCUMENT' limit 1);
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`,`uiDisplayCode`) 
VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'FEE_PAYER_DOCUMENT_STATUS_UPDATE', 'Fee Payer Document Status Update', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Fee Payer Document Status Update', 'Fee Payer Document Status Update');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf limit 1);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope limit 1);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope limit 1);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope limit 1);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope limit 1);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope limit 1);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- DL data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider limit 1);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'FEE_PAYER_DOCUMENT_STATUS_UPDATE_DL', 'SQL');

-- Recipient Infor data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider limit 1);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'FEE_PAYER_DOCUMENT_STATUS_UPDATE_RCPNT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type limit 1);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='FEE_PAYER_DOCUMENT_STATUS_UPDATE_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`,`idParamName`) VALUES (@msgRecipientId+1, @dtproviderId, 'FEE_PAYER_DOCUMENT_STATUS_UPDATE_RCPNT','CONTEXT_RECORD_ID');


-- The under sql code gives for the user distribution list ,this information can be fetched
SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf` limit 1);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='FEE_PAYER_DOCUMENT_STATUS_UPDATE_DL' limit 1);
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='FEE_PAYER_DOCUMENT_STATUS_UPDATE_RCPNT' limit 1);
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

-- Setting the query for the Parent distribution list
SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider` limit 1);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='FEE_PAYER_DOCUMENT_STATUS_UPDATE_DL' limit 1);
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select distinct T1.id AS USER_ID 
from student_documents T1 where T1.id in(namedParams) ",NULL); 

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider` limit 1);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='FEE_PAYER_DOCUMENT_STATUS_UPDATE_RCPNT' limit 1);
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T1.id AS ID,
    T2.firstName AS FIRST_NAME,
    T2.middleName AS MIDDLE_NAME,
    T2.lastName AS LAST_NAME,
    T2.companyName AS COMPANY_NAME,
 	T2.feePayerPrintName as PRINT_NAME,
 	T2.mobileNumber as MOBILE_NO,
 	T2.emailHome as EMAIL_ID,
 	T3.itemValue AS DOCUMENT_STATUS,
    T4.itemValue AS DOCUMENT_TYPE,
	SUBSTRING_INDEX(T5.documentName, '\\\\', -1) AS DOCUMENT_NAME,
	T6.firstName AS STUDENT_FIRST_NAME,
    T6.middleName AS STUDENT_MIDDLE_NAME,
    T6.lastName AS STUDENT_LAST_NAME,
    T8.code AS STUDENT_CODE,
    T9.salutationName AS TITLE,
    T11.code as  INSPECTION_BY,
	T13.displayName as CAMPUS_NAME
FROM
    student_documents AS T1
        JOIN
    fee_payer_detail AS T2 ON T2.id = T1.feePayerId
        JOIN
    document_status AS T3 ON T3.id = T1.documentStatusId
        JOIN
    document_types AS T4 ON T4.id = T1.documentTypeId
        JOIN
    documents AS T5 ON T5.id = T1.documentId
        JOIN
    persons T6 ON T6.id = T2.personId
        JOIN
    students T7 ON T7.personId = T6.id
        JOIN
    users T8 ON T8.id = T7.userId
        JOIN
     salutations T9 ON T9.id = T2.salutationId
         JOIN
    extended_documents T10 ON T10.documentId = T5.id
        LEFT JOIN
    users T11 ON T11.id = T10.inspectionDoneBy
		JOIN
   admission T12 on T12.studentId=T8.id  AND T12.activeStatus is true
        JOIN
   academy_location T13 on T13.id=T12.academyLocationId
where  T1.id in (namedParams) group by T1.id",
'{
 "id": 1,
     "searchResultViewColumns": [
      {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },{
            "id": 3,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        }, {
            "id": 5,
            "value": "emailHome",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 4
        },        
        {
            "id": 6,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 5
        },
		 {
            "id": 7,
            "value": "feePayerPrintName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 7
        },        
        {
            "id": 9,
            "value": "middleName",
            "resultKey": "STUDENT_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
      	{
            "id": 10,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 9
        },       
        {
            "id": 11,
            "value": "code",
            "resultKey": "STUDENT_CODE",
            "displayCode": "",
            "displayOrder": 10
        }, 
 		{
            "id": 12,
            "value": "itemValue",
            "resultKey": "DOCUMENT_TYPE",
            "displayCode": "",
            "displayOrder": 11
        },
 		{
            "id": 13,
            "value": "itemValue",
            "resultKey": "DOCUMENT_STATUS",
            "displayCode": "",
            "displayOrder": 12
        },  
		{
            "id": 14,
            "value": "documentName",
            "resultKey": "DOCUMENT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },      
        {
            "id": 15,
            "value": "companyName",
            "resultKey": "COMPANY_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "salutationName",
            "resultKey": "TITLE",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "code",
            "resultKey": "INSPECTION_BY",
            "displayCode": "",
            "displayOrder": 16
        },{
            "id": 18,
            "value": "displayName",
            "resultKey": "CAMPUS_NAME",
            "displayCode": "",
            "displayOrder": 17
        }
		
    ]}');

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template limit 1);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='FEE_PAYER_DOCUMENT_STATUS_UPDATE' limit 1);

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config limit 1);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='FEE_PAYER_DOCUMENT' limit 1);
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='FEE_PAYER_DOCUMENT_STATUS_UPDATE_RCPNT' limit 1);
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications' limit 1);

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Fee Payer Document Status Update',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Fee Payer Document Status Update',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1','English',1);

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Fee Payer Document Status Update','<html>
<head>
    <title></title>
</head>
<body bgcolor="silver">
<p>
Dear <b>$recipientData["FIRST_NAME"]</b>, <br>
Please note that the Fee Payer ID/Proof of Bank Account has been rejected by <b>$recipientData["CAMPUS_NAME"]</b>. <br><br>
Please review the documents submitted during Re-registration and ensure that the correct documents 
have been uploaded. 
</p>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'2','Fee Payer Document Status Update',
'<html>
<head>
    <title></title>
</head>
<body bgcolor="silver">
<p>
Dear <b>$recipientData["FIRST_NAME"]</b>, <br>
Please note that the Fee Payer ID/Proof of Bank Account has been rejected by <b>$recipientData["CAMPUS_NAME"]</b>. <br><br>
Please review the documents submitted during Re-registration and ensure that the correct documents 
have been uploaded. 
</p>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'4','Fee Payer Document Status Update',
'<html>
<head>
    <title></title>
</head>
<body bgcolor="silver">
<p>
Dear <b>$recipientData["FIRST_NAME"]</b>, <br>
Please note that the Fee Payer ID/Proof of Bank Account has been rejected by <b>$recipientData["CAMPUS_NAME"]</b>. <br><br>
Please review the documents submitted during Re-registration and ensure that the correct documents 
have been uploaded. 
</p>
</body>
</html>');

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='FEE_PAYER_DOCUMENT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'FEE_PAYER_DOCUMENT', 'Fee Payer Document', 'Fee Payer Document', 'Fooi betaler Dokument', 'Giấy tờ của người nộp phí',now(),1);
END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='FEE_PAYER_DOCUMENT_STATUS_UPDATE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'FEE_PAYER_DOCUMENT_STATUS_UPDATE', 'Fee Payer Document Status Update', 'Fee Payer Document Status Update', 'Statusopdatering van fooibetalerdokument', 'Cập nhật trạng thái tài liệu của người nộp phí',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='FEE_PAYER_DOCUMENT_STATUS_UPDATE_DL')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'FEE_PAYER_DOCUMENT_STATUS_UPDATE_DL', 'Fee Payer Document Status Update DL', 'Fee Payer Document Status Update DL', 'Statusopdatering van fooibetalerdokument DL', 'Cập nhật trạng thái tài liệu của người nộp lệ phí DL',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='FEE_PAYER_DOCUMENT_STATUS_UPDATE_RCPNT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'FEE_PAYER_DOCUMENT_STATUS_UPDATE_RCPNT', 'Fee Payer Document Status Update Recipient', 'Fee Payer Document Status Update Recipient', 'Ontvanger van statusopdatering vir fooibetalerdokument', 'Người nộp lệ phí Cập nhật trạng thái tài liệu Người nhận',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='INSPECTION_BY')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'INSPECTION_BY', 'Inspection By', 'Inspection By', 'Inspeksie Deur', 'Kiểm tra bởi',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='CAMPUS_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'CAMPUS_NAME', 'Campus Name', 'Campus Name', 'Kampus Naam', 'Tên trường',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_CODE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'STUDENT_CODE', 'Student Code', 'Student Code', 'Studentekode', 'Mã sinh viên',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='DOCUMENT_STATUS')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'DOCUMENT_STATUS', 'Document Status', 'Document Status', 'Dokument Status', 'Trạng thái tài liệu',now(),1);
END IF;
 
IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='COMPANY_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'COMPANY_NAME', 'Company Name', 'Company Name', 'Maatskappy Naam', 'Tên công ty',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='TITLE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'TITLE', 'Title', 'Title', 'Titel', 'Tiêu đề',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='FEE_PAYER_DOCUMENT_STATUS_UPDATE')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('FEE_PAYER_DOCUMENT_STATUS_UPDATE', 'Fee Payer Document Status Update');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='FEE_PAYER_DOCUMENT_STATUS_UPDATE_DL')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('FEE_PAYER_DOCUMENT_STATUS_UPDATE_DL', 'Fee Payer Document Status Update DL');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='FEE_PAYER_DOCUMENT_STATUS_UPDATE_RCPNT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('FEE_PAYER_DOCUMENT_STATUS_UPDATE_RCPNT', 'Fee Payer Document Status Update Recipient');
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='FEE_PAYER_DOCUMENT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('FEE_PAYER_DOCUMENT', 'Fee Payer Document');
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='FEE_PAYER_DOCUMENT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'FEE_PAYER_DOCUMENT', 'Fee Payer Document', 'Fee Payer Document', 'Fooi betaler Dokument', 'Giấy tờ của người nộp phí',now(),1);
END IF;



END $$
CALL V20251209112049__Insert_studentDocumentFeePayerEvent() $$
DROP PROCEDURE IF EXISTS V20251209112049__Insert_studentDocumentFeePayerEvent $$
DELIMITER ;