DELIMITER $$
DROP PROCEDURE IF EXISTS V20251212171746__Update_PassoutLetterDynamicDocument $$
CREATE PROCEDURE V20251212171746__Update_PassoutLetterDynamicDocument()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF EXISTS (select 1 from dydt_data_provider where  providerName='PROGRAM_GROUP_CATEGORY_DATA_PROVIDER_INFO') then 
SET @dataProviderId=(select MAX(id) from dydt_data_provider where  providerName='PROGRAM_GROUP_CATEGORY_DATA_PROVIDER_INFO');
SET @dydtdatalinitemId=(select Max(id) from dydt_data_line_item where  dataSourceCode='PASSOUT_LETTER' and dataProviderId = @dataProviderId);
END IF;

IF EXISTS ((select * from dydt_data_line_item where  dataSourceCode='PASSOUT_LETTER' AND dataProviderId = @dataProviderId)) THEN 
update dydt_data_line_item set resultColumnsDef  ='STUDENT_ID,STUDENT_PRINT_NAME,FIRST_NAME,MIDDLE_NAME,LAST_NAME,MOBILE_NO,EMAIL_ID,STUDENT_ADMITTED_PROGRAM_NAME,STUDENT_ADMITTED_PROGRAM_CODE,STUDENT_BATCH,STUDENT_GRADUATED_PERIOD_NAME,PROGRAM_PERIOD_END_DATE,STUDENT_GRADUATED_ACADEMIC_TERM,ACADEMY_LOCATION_WEBSITE_URL,HEADER_IMAGE_URL,FOOTER_IMAGE_URL,ACADEMY_NAME,LOCATION_NAME,ACADEMY_LOCATION_DISPLAY_NAME,ACADEMY_LOCATION_EMAIL_ID,ACADEMY_LOCATION_PHONE_CODE,ACADEMY_LOCATION_PHONE_AREA_CODE,ACADEMY_LOCATION_PHONE_NO,ACADEMY_LOCATION_MOBILE_CODE,ACADEMY_LOCATION_MOBILE_NO,PROGRAM_GROUP,PROGRAM_CATEGORY,
NQF_Level,Number_of_Credits,SAQA_Id,addressText,countryName,cityName'
, sqlSelectQueryDef =  "select DISTINCT 
    T1.id As ID ,
    T3.code AS STUDENT_ID,
    p.printName AS STUDENT_PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.middleName AS MIDDLE_NAME,
    p.lastName AS LAST_NAME,
    p.mobileNumber AS MOBILE_NO,
    p.emailId AS EMAIL_ID,
    T9.programNameToBePrint AS STUDENT_ADMITTED_PROGRAM_NAME,
    T9.programCode AS STUDENT_ADMITTED_PROGRAM_CODE,
    T10.printName AS STUDENT_BATCH,
    T12.printName AS STUDENT_GRADUATED_PERIOD_NAME,
    T12.programPeriodEnd AS PROGRAM_PERIOD_END_DATE,
    T13.itemValue AS STUDENT_GRADUATED_ACADEMIC_TERM, 
    T15.websiteURL AS ACADEMY_LOCATION_WEBSITE_URL,
    (CASE
        WHEN
            T5.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.headerUrl)
        ELSE NULL
    END) AS HEADER_IMAGE_URL,
    (CASE
        WHEN
            T5.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.footerUrl)
        ELSE NULL
    END) AS FOOTER_IMAGE_URL,
    T5.academyName AS ACADEMY_NAME,
    T5.locationName AS LOCATION_NAME,
    T5.displayName AS ACADEMY_LOCATION_DISPLAY_NAME,
    T8.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T8.phoneCountryCode AS ACADEMY_LOCATION_PHONE_CODE,
    T8.phoneAreaCode AS ACADEMY_LOCATION_PHONE_AREA_CODE,
    T8.phoneNo AS ACADEMY_LOCATION_PHONE_NO,
    T8.cellCountryCode AS ACADEMY_LOCATION_MOBILE_CODE,
    T8.cellNo AS ACADEMY_LOCATION_MOBILE_NO,
    pg.groupName as PROGRAM_GROUP,
	pc.categoryName as PROGRAM_CATEGORY,
    hq.itemValue as NQF_Level,
    T10.minProgramCredits as Number_of_Credits,
    T9.saqaId as SAQA_Id,
    T18.addressText as addressText,
    T20.countryName as countryName,
    T21.cityName as cityName
 FROM completions T1
	LEFT JOIN
     students T2 ON T2.userId = T1.studentId
    LEFT JOIN  
    persons p on p.id = T2.personId
	LEFT JOIN
    users T3 ON T2.userId = T3.id
    LEFT JOIN
	admission T4 on T4.id = T1.admissionId
    LEFT JOIN
    academy_location T5 on T5.id = T4.academyLocationId
    LEFT JOIN 
    locations T6 on T6.id = T5.locationId
    LEFT JOIN 
    location_addresses T7 on T7.locationId = T6.id
    LEFT JOIN 
    address T8 on T8.id = T7.addressId
    LEFT JOIN
    programs T9 on T9.id = T1.programId
    LEFT JOIN 
    program_group pg on pg.id=T9.programGroupId
    LEFT JOIN 
    program_category pc on pc.id=T9.programCategoryId
    LEFT JOIN 
    batches T10 on T10.id = T1.batchId
    LEFT JOIN 
    program_batch_students T11 on T11.id = T4.id
    LEFT JOIN 
    prog_batch_period_config T12 on T12.id = T11.progBatchPeriodConfigId
    LEFT JOIN 
    academic_term T13 on T13.id = T12.academicTermId
    LEFT JOIN    
    organizations org ON org.id = (SELECT max(id) FROM organizations)
    LEFT JOIN 
    organization_addresses T14 ON org.id=T14.organizationId
    LEFT JOIN 
    address T15 on T15.id = T14.addressId
    LEFT JOIN 
    address_type T16 ON T16.id=T8.addressTypeId
     LEFT JOIN 
    person_addresses T17 on T17.personId = p.id
    LEFT JOIN 
    address T18 on T18.id=T17.addressId
    LEFT JOIN 
    address_type T19 on T19.id=T17.addressTypeId and T19.code ='CRNT' and T19.addressCategory='PERSON'
     LEFT JOIN 
    city T21 on T21.id=T18.cityId
    LEFT JOIN 
    country T20 on T20.id=T21.countryId
    LEFT JOIN 
    heqf_level hq ON hq.id=T9.heqfLevelId" ,
    sqlWhereQueryDef='where T1.id in (PRM_STUDENT_ID) and T15.addressTypeId=1'
where dataSourceCode='PASSOUT_LETTER'  AND dataProviderId = @dataProviderId  ; 
END IF; 

 IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'PROGRAM_PERIOD_END_DATE' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('PROGRAM_PERIOD_END_DATE', 'Program Period End Date', @dydtdatalinitemId);
 END IF;
 
  IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'NQF_Level' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('NQF_Level', 'NQF Level', @dydtdatalinitemId);
 END IF;
 
 IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'Number_of_Credits' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('Number_of_Credits', 'Program Credit', @dydtdatalinitemId);
 END IF;
 
 IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'SAQA_Id' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('SAQA_Id', 'SAQA ID', @dydtdatalinitemId);
 END IF;
 
 IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'addressText' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('addressText', 'Student Address', @dydtdatalinitemId);
 END IF;
 
 IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'countryName' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('countryName', 'Student Country Name', @dydtdatalinitemId);
 END IF;
 
 IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'cityName' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('cityName', 'Student City Name', @dydtdatalinitemId);
 END IF;

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251212171746__Update_PassoutLetterDynamicDocument () $$
DROP PROCEDURE IF EXISTS V20251212171746__Update_PassoutLetterDynamicDocument $$
DELIMITER ;