DELIMITER $$
DROP PROCEDURE IF EXISTS fatchCreditNoteTobePushedInXero $$
CREATE PROCEDURE fatchCreditNoteTobePushedInXero(jobLastRunTimestamp timestamp)
BEGIN


SELECT 
    FUNC_INC_VAR_SESSION_REC() AS id,
    xUser.xeroContactId AS xeroContactId,
    NULL AS academiaSponsorId,
    xUser.academiaUserId AS academiaUserId,
    bill.totalAmount AS unitAmount,
    bill.billNo AS invoiceNumber,
    bill.id AS billHeaderId,
    curr.currencyCode AS currencyCode,
    bill.billingDate AS billingDate,
    bill.dueDate AS dueDate,
    bill.reasonForManualBill AS reason,
    bill.billStatus AS billStatus,
    bill.academyLocationId AS academyLocationId,
    bill.cancellationDate AS cancellationDate,
    bill.cancellationNarration AS cancellationNarration,
    bill.raiseBillCategory AS raiseBillCategory,
    xeroCredMap.id AS xeroCredDbId,

   
    CASE 
        WHEN feeHeadMap.value IS NOT NULL THEN feeHeadMap.value
        ELSE prog.programNameLanguageThree
    END AS accountCode,

    xeroCredMap.createdDate AS createdDate,

  
    prog.programName AS programCode,
    fp.feePlanName AS feePlanName,
    c.courseName AS courseName,
    c.courseCode AS courseCode,

    
    CASE
        WHEN fpr.feeRuleDesc IS NULL OR fpr.feeRuleDesc = '' 
            THEN fp.feePlanName
        ELSE CONCAT(bill.raiseBillType, '/', fpr.feeRuleDesc)
    END AS reference

FROM
    xero_user_mapping xUser
    JOIN bill_header bill 
        ON bill.studentId = xUser.academiaUserId
        AND bill.raiseBillCategory <> 'BILL_RECEIVABLE'

   
    INNER JOIN bill_fee_plan_rule_stage bfprs
        ON bfprs.billId = bill.id
    INNER JOIN fee_stage_head_config fshc
        ON fshc.id = bfprs.feeStageHeadConfigId
    INNER JOIN fee_plan_rule_stage fprs
        ON fshc.feePlanRuleStageId = fprs.id
    INNER JOIN fee_plan_rules fpr
        ON fpr.id = fprs.feePlanRuleId
    INNER JOIN fee_plan fp
        ON fp.id = fpr.feePlanId

    
    JOIN prog_batch_seat_config pbsc 
        ON pbsc.id = bill.programBatchSeatConfigId
    JOIN batches batch 
        ON batch.id = pbsc.programBatchId
    JOIN programs prog 
        ON prog.id = batch.programId

   
    LEFT JOIN currency curr 
        ON bill.currencyId = curr.id

   
    LEFT JOIN xero_credit_note_mapping xeroCredMap 
        ON xeroCredMap.academiaBillHeaderId = bill.id
        AND bill.academyLocationId = xeroCredMap.academyLocationId

    
    LEFT JOIN drop_down drp 
        ON drp.type = 'XeroRetriggerMaxAttemptDays'

    
    LEFT JOIN student_course_enrollment sce 
        ON sce.admissionId = bill.admissionId
    LEFT JOIN courses c 
        ON c.id = sce.courseVarientId

   
    LEFT JOIN bill_fee_plan_rule_stage bfs 
        ON bfs.billId = bill.id
    LEFT JOIN fee_stage_head_config fshc2 
        ON fshc2.id = bfs.feeStageHeadConfigId
    LEFT JOIN fee_heads feeHead 
        ON feeHead.id = fshc2.feeHeadId

    LEFT JOIN drop_down feeHeadMap
        ON feeHeadMap.type = 'xeroFeeHead'
        AND feeHeadMap.name = feeHead.feeHeadName

WHERE
    bill.totalAmount IS NOT NULL
    AND (
            xeroCredMap.id IS NULL 
            OR (
                xeroCredMap.error IS NOT NULL
                AND (xeroCredMap.createdDate 
                     + INTERVAL CAST(drp.value AS SIGNED) DAY) >= CURRENT_DATE
            )
        )
GROUP BY bill.id;

END $$

DELIMITER ;