set foreign_key_checks=0;
ALTER TABLE `course_coverage_plan` 
ADD COLUMN `facultyCourseAttendanceId` BIGINT(20) NULL AFTER `noOfParticipants`,
ADD COLUMN `studentCourseAttendanceId` BIGINT(20) NULL AFTER `facultyCourseAttendanceId`;

ALTER TABLE `course_coverage_plan` 
ADD INDEX `fk_course_coverage_plan_1_idx1` (`facultyCourseAttendanceId` ASC);
ALTER TABLE `course_coverage_plan` 
ADD CONSTRAINT `fk_course_coverage_plan_11`
  FOREIGN KEY (`facultyCourseAttendanceId`)
  REFERENCES `faculty_course_attendance` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

ALTER TABLE `course_coverage_plan` 
ADD INDEX `fk_course_coverage_plan_2_idx` (`studentCourseAttendanceId` ASC);
ALTER TABLE `course_coverage_plan` 
ADD CONSTRAINT `fk_course_coverage_plan_2`
  FOREIGN KEY (`studentCourseAttendanceId`)
  REFERENCES `student_course_attendance` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
set foreign_key_checks=1;


-- delayed course PBS
DROP VIEW IF EXISTS `pnc_dashboard_delayed_course_pbs`;
CREATE VIEW `pnc_dashboard_delayed_course_pbs` AS
select 
    course_coverage_plan.academyLocationId,
    batches.programId,
    course_coverage_plan.programBatchId,
    course_coverage_plan.periodId,
    course_coverage_plan.courseId,
    course_coverage_plan.sectionId,
    concat(academy_location.academyName, " - ", academy_location.locationName) as `AcademyLocation`,
    programs.programNameToBePrint as `ProgramName`,
    batches.batchName as `BatchName`,
    prog_batch_period_config.programPeriodName as `PeriodName`,
    courses.courseName as `CourseName`,
    course_variants.courseVariantCode as `CourseVariantCode`,
    users.printName as `facultyName`,
    count(*) as `TotalSessions`,
    count(case when sessionDate<=SYSDATE() and facultyCourseAttendanceId is not null then facultyCourseAttendanceId end) "SesssionConductedTillDate",
    count(case when sessionDate<=SYSDATE() then course_coverage_plan.id end) "DueTillDate",
    (
    count(case when sessionDate<=SYSDATE() then course_coverage_plan.id end)
    -
    count(case when sessionDate<=SYSDATE() and facultyCourseAttendanceId is not null then facultyCourseAttendanceId end)
    ) as "Deviation"
from
    course_coverage_plan
left outer join
    academy_location on course_coverage_plan.academyLocationId = academy_location.id
left outer join
    batches on course_coverage_plan.programBatchId = batches.id
left outer join
    programs on batches.programId = programs.id
left outer join
    prog_batch_period_config on course_coverage_plan.periodId = prog_batch_period_config.id
left outer join
    courses on course_coverage_plan.courseId = courses.id
left outer join
    course_variants on course_coverage_plan.courseVariantId = course_variants.id
left outer join
    users on course_coverage_plan.facultyId = users.id
where    
    courses.assignSectionType = "ProgramBatchSection"
group by
    course_coverage_plan.courseVariantId, 
    course_coverage_plan.slotFrom, 
    course_coverage_plan.slotTo
;  

-- delayed Course CBS
DROP VIEW IF EXISTS `pnc_dashboard_delayed_course_cbs`;
CREATE VIEW `pnc_dashboard_delayed_course_cbs` AS
select 
    course_coverage_plan.academyLocationId,
    course_coverage_plan.courseId,
    course_coverage_plan.sectionId,
    concat(academy_location.academyName, " - ", academy_location.locationName) as `AcademyLocation`,
    courses.courseName as `CourseName`,
    course_variants.courseVariantCode as `CourseVariantCode`,
    users.printName as `facultyName`,
    count(*) as `TotalSessions`,
    count(case when sessionDate<=SYSDATE() and facultyCourseAttendanceId is not null then facultyCourseAttendanceId end) "SesssionConductedTillDate",
    count(case when sessionDate<=SYSDATE() then course_coverage_plan.id end) "DueTillDate",
    (
    count(case when sessionDate<=SYSDATE() then course_coverage_plan.id end)
    -
    count(case when sessionDate<=SYSDATE() and facultyCourseAttendanceId is not null then facultyCourseAttendanceId end)
    ) as "Deviation"
from
    course_coverage_plan
left outer join
    academy_location on course_coverage_plan.academyLocationId = academy_location.id
left outer join
    courses on course_coverage_plan.courseId = courses.id
left outer join
    course_variants on course_coverage_plan.courseVariantId = course_variants.id
left outer join
    users on course_coverage_plan.facultyId = users.id
where
    courses.assignSectionType = "CourseSection"
group by
    course_coverage_plan.courseVariantId, 
    course_coverage_plan.slotFrom, 
    course_coverage_plan.slotTo
; 