CREATE TABLE `application_fee_details` (
  `id` bigint(20) NOT NULL,
  `applicationId` bigint(20) NOT NULL,
  `applicationProgramId` bigint(20) NOT NULL,
  `stageId` bigint(20) DEFAULT NULL,
  `feeStageId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `feeAmount` double(10,2) DEFAULT NULL,
  `paidStatus` bit(1) DEFAULT NULL,
  `receiptHeaderId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refapplication989_idx` (`applicationId`),
  KEY `Refapplicationprogram76_idx` (`applicationProgramId`),
  KEY `Reffeestage767_idx` (`feeStageId`),
  KEY `Reffeeplan_idx` (`feePlanId`),
  KEY `Refreceipt787_idx` (`receiptHeaderId`),
  KEY `Refusers67_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refusers67` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refapplication989` FOREIGN KEY (`applicationId`) REFERENCES `application` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refapplicationprogram76` FOREIGN KEY (`applicationProgramId`) REFERENCES `application_program` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Reffeeplan` FOREIGN KEY (`feePlanId`) REFERENCES `fee_plan` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Reffeestage767` FOREIGN KEY (`feeStageId`) REFERENCES `fee_stage_master` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refreceipt787` FOREIGN KEY (`receiptHeaderId`) REFERENCES `receipt_header` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;