DROP VIEW IF EXISTS `course_evaluation_report`;
CREATE VIEW `course_evaluation_report` AS 
select 
	c1.id,
	course_variants.courseVariantCode "variantCode",
	(
		case
			when c1.parentCourseId is null then c1.courseName 
			else c2.courseName
		end
	) AS "courseName",
	 evaluation_plan.evaluationPlanNumber "evaluationPlanNumber"
from
    evaluation_type_course
left outer join
	evaluation_plan on evaluation_type_course.evaluationPlanId = evaluation_plan.id
left outer join
	course_variants on evaluation_type_course.courseVariantId = course_variants.id
left outer join
	courses  c1 on course_variants.courseId = c1.id
left outer join
	courses c2 on c1.parentCourseId = c2.id;