DROP VIEW IF EXISTS `pnc_dashboard_program_with_vacants_seats`;
CREATE VIEW `pnc_dashboard_program_with_vacants_seats` AS
    select 
        concat(`academy_location`.`academyName`,
                ' - ',
                `academy_location`.`locationName`) AS `AcademyLocation`,
        `programs`.`programCode` AS `programCode`,
        `academy_location`.`id` AS `academyLocationId`,
        `programs`.`programName` AS `programName`,
        `batches`.`id` AS `id`,
        `batches`.`batchName` AS `batchName`,
        `batches`.`seatCapacity` AS `seatCapacity`,
        (`batches`.`seatCapacity` - count(0)) AS `seatVacant`
    from
        (((`admission`
        left join `batches` ON ((`admission`.`batchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `academy_location` ON ((`admission`.`academyLocationId` = `academy_location`.`id`)))
    group by `admission`.`batchId`
    having ((`batches`.`seatCapacity` - count(0)) > 0);
