DROP TABLE IF EXISTS `course_group_completion`;
CREATE TABLE `course_group_completion` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `courseGroupId` bigint(20) NOT NULL,
  `admissionId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_course_group_completion_1_idx` (`courseGroupId`),
  KEY `fk_course_group_completion_2_idx` (`admissionId`),
  KEY `fk_course_group_completion_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_course_group_completion_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_course_group_completion_1` FOREIGN KEY (`courseGroupId`) REFERENCES `course_group` (`id`),
  CONSTRAINT `fk_course_group_completion_2` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`)
);