DROP TABLE IF EXISTS `compln_check_trans_certs`;
CREATE TABLE `compln_check_trans_certs`(  
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `completionCheckListId` BIGINT(20),
  `certificateId` BIGINT(20),
  `transactionTypeId` BIGINT(20),
  `lastUpdate` TIMESTAMP NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  FOREIGN KEY (`completionCheckListId`) REFERENCES `completion_checklists`(`id`),
  FOREIGN KEY (`certificateId`) REFERENCES `certificates`(`id`),
  FOREIGN KEY (`transactionTypeId`) REFERENCES `transaction_types`(`id`),
  FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);


DROP TABLE IF EXISTS `compln_check_trans_checks`;
CREATE TABLE `compln_check_trans_checks`(  
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `completionCheckListId` BIGINT(20),
  `checklistItemId` BIGINT(20),
  `transactionTypeId` BIGINT(20),
  `lastUpdate` TIMESTAMP NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  FOREIGN KEY (`completionCheckListId`) REFERENCES `completion_checklists`(`id`),
  FOREIGN KEY (`checklistItemId`) REFERENCES `checklist_items`(`id`),
  FOREIGN KEY (`transactionTypeId`) REFERENCES `transaction_types`(`id`),
  FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);

ALTER TABLE `transaction_types`   
  ADD COLUMN `completionTransactionType` VARCHAR(50) NOT NULL AFTER `id`;
