/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.resolver.sql;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.SqlScript;
import com.googlecode.flyway.core.resolver.MigrationExecutor;
import com.googlecode.flyway.core.util.PlaceholderReplacer;
import com.googlecode.flyway.core.util.Resource;
import java.sql.Connection;

public class SqlMigrationExecutor
implements MigrationExecutor {
    private final DbSupport dbSupport;
    private final PlaceholderReplacer placeholderReplacer;
    private final Resource sqlScriptResource;
    private final String encoding;

    public SqlMigrationExecutor(DbSupport dbSupport, Resource sqlScriptResource, PlaceholderReplacer placeholderReplacer, String encoding) {
        this.dbSupport = dbSupport;
        this.sqlScriptResource = sqlScriptResource;
        this.encoding = encoding;
        this.placeholderReplacer = placeholderReplacer;
    }

    public void execute(Connection connection) {
        String sqlScriptSource = this.sqlScriptResource.loadAsString(this.encoding);
        String sqlScriptSourceNoPlaceholders = this.placeholderReplacer.replacePlaceholders(sqlScriptSource);
        SqlScript sqlScript = new SqlScript(sqlScriptSourceNoPlaceholders, this.dbSupport);
        sqlScript.execute(new JdbcTemplate(connection, 0));
    }
}

