/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.CriteriaBuilderConfigurer;

import com.googlecode.flyway.core.Flyway;
import in.serosoft.CriteriaBuilderConfigurer.ConfigUtil;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class FlywayConfigurerApp {
    public static void main(String ... args) {
        ApplicationContext appContext = ConfigUtil.getApplicationContext();
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(() -> FlywayConfigurerApp.mainFlyway(appContext));
        executor.execute(() -> FlywayConfigurerApp.auditFlyway(appContext));
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ((ConfigurableApplicationContext)appContext).close();
    }

    private static void mainFlyway(ApplicationContext appContext) {
        try {
            System.out.println("Main flyway starting..." + new Date());
            appContext.getBean("flyway", Flyway.class);
        }
        catch (BeansException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Main flyway executed at: " + new Date());
    }

    private static void auditFlyway(ApplicationContext appContext) {
        try {
            System.out.println("Audit flyway starting..." + new Date());
            appContext.getBean("auditFlyway", Flyway.class);
        }
        catch (BeansException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Audit flyway executed at: " + new Date());
    }
}

