/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.cb.helper;

import in.serosoft.cb.entity.SearchConfig;
import in.serosoft.cb.entity.SearchConfigTable;
import in.serosoft.cb.entity.SearchResultView;
import in.serosoft.cb.entity.SearchTable;
import in.serosoft.cb.entity.SearchTableColumn;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SavedSearchConfigurationHelper {
    public static Map<String, SearchConfig> buildSearchConfigMap(List<SearchConfig> searchConfigs) {
        HashMap<String, SearchConfig> searchConfigMap = new HashMap<String, SearchConfig>();
        for (SearchConfig searchConfig : searchConfigs) {
            searchConfigMap.put(searchConfig.getConfigCode(), searchConfig);
        }
        return searchConfigMap;
    }

    public static Map<String, SearchResultView> buildSearchResultViewMap(List<SearchResultView> searchResultViews) {
        HashMap<String, SearchResultView> searchResultViewMap = new HashMap<String, SearchResultView>();
        for (SearchResultView searchResultView : searchResultViews) {
            searchResultViewMap.put(searchResultView.getViewCode(), searchResultView);
        }
        return searchResultViewMap;
    }

    public static Map<String, Map<String, SearchConfigTable>> buildSearchConfigTablesMap(List<SearchConfig> searchConfigs) {
        HashMap<String, Map<String, SearchConfigTable>> searchConfigTablesMap = new HashMap<String, Map<String, SearchConfigTable>>();
        for (SearchConfig searchConfig : searchConfigs) {
            Set<SearchConfigTable> searchConfigTables = searchConfig.getSearchConfigurationTables();
            HashMap<String, SearchConfigTable> searchConfigTableMap = new HashMap<String, SearchConfigTable>();
            for (SearchConfigTable searchConfigTable : searchConfigTables) {
                searchConfigTableMap.put(searchConfigTable.getAlias() + "#" + searchConfigTable.getSearchTableBySearchTableId().getDbTableName(), searchConfigTable);
            }
            searchConfigTablesMap.put(searchConfig.getConfigCode(), searchConfigTableMap);
        }
        return searchConfigTablesMap;
    }

    public static SearchConfigTable findSearchConfigTable(String configCode, String tableName, Map<String, Map<String, SearchConfigTable>> searchConfigTablesMap) {
        Map<String, SearchConfigTable> searchConfigTableMap = searchConfigTablesMap.get(configCode);
        SearchConfigTable searchConfigTable = searchConfigTableMap.get(tableName);
        return searchConfigTable;
    }

    public static SearchTableColumn findSearchTableColumn(SearchConfigTable searchConfigTable, String columnName) {
        SearchTable searchTable = searchConfigTable.getSearchTableBySearchTableId();
        Set<SearchTableColumn> searchTableColumns = searchTable.getSearchTableColumns();
        for (SearchTableColumn searchTableColumn : searchTableColumns) {
            if (!columnName.equals(searchTableColumn.getColumnName())) continue;
            return searchTableColumn;
        }
        return null;
    }
}

