/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.cb.helper;

import in.serosoft.cb.dao.SearchTableColumnDAO;
import in.serosoft.cb.dao.SearchTableRelationDAO;
import in.serosoft.cb.entity.SearchAggregationColumn;
import in.serosoft.cb.entity.SearchConfigTable;
import in.serosoft.cb.entity.SearchResultFormatterParams;
import in.serosoft.cb.entity.SearchResultView;
import in.serosoft.cb.entity.SearchResultViewColumn;
import in.serosoft.cb.entity.SearchResultViewSort;
import in.serosoft.cb.entity.SearchSQLGroup;
import in.serosoft.cb.entity.SearchSQLGroupBy;
import in.serosoft.cb.entity.SearchTable;
import in.serosoft.cb.entity.SearchTableColumn;
import in.serosoft.cb.entity.SearchTableRelation;
import in.serosoft.cb.helper.ConfigurationHelper;
import in.serosoft.cb.model.SearchAggregateColumnDTO;
import in.serosoft.cb.model.SearchResultFormatterParamsDTO;
import in.serosoft.cb.model.SearchResultViewColumnDTO;
import in.serosoft.cb.model.SearchResultViewDTO;
import in.serosoft.cb.model.SearchResultViewSortDTO;
import in.serosoft.cb.model.SearchSQLGroupByDTO;
import in.serosoft.cb.model.SearchSQLGroupDTO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SearchResultViewDTOToEntityConvertor {
    SearchTableRelationDAO searchTableRelationDAO;
    SearchTableColumnDAO searchTableColumnDAO;
    Map<String, SearchTable> searchTablesMap;
    List<SearchTableRelation> searchTableRelations;
    Map<String, SearchConfigTable> searchConfigTablesMap = new HashMap<String, SearchConfigTable>();
    Map<String, SearchResultViewColumn> searchResultViewColumnMap = new HashMap<String, SearchResultViewColumn>();
    Map<String, SearchSQLGroup> searchSQLGroupMap = new HashMap<String, SearchSQLGroup>();
    SearchConfigTable rootSearchConfigTable = new SearchConfigTable();
    SearchResultView defaultSearchResultView = new SearchResultView();

    public SearchResultViewDTOToEntityConvertor(Map<String, SearchTable> searchTablesMap, List<SearchTableRelation> searchTableRelations, SearchTableRelationDAO searchTableRelationDAO, SearchTableColumnDAO searchTableColumnDAO, Map<String, SearchConfigTable> searchConfigTablesMap) {
        this.searchTablesMap = searchTablesMap;
        this.searchTableRelations = searchTableRelations;
        this.searchTableRelationDAO = searchTableRelationDAO;
        this.searchTableColumnDAO = searchTableColumnDAO;
        this.searchConfigTablesMap = searchConfigTablesMap;
    }

    public SearchResultView convertSearchResultViewDTOToEntity(SearchResultViewDTO searchResultViewDTO) {
        SearchResultView nextSearchResultView = this.convertSearchResultViewDTOToSearchResultView(searchResultViewDTO);
        return nextSearchResultView;
    }

    public SearchResultView convertSearchResultViewDTOToSearchResultView(SearchResultViewDTO searchResultViewDTO) {
        SearchResultView searchResultView = new SearchResultView();
        searchResultView.setViewCode(searchResultViewDTO.getViewCode());
        HashSet<SearchResultViewColumn> searchResultViewColumns = new HashSet<SearchResultViewColumn>();
        List<SearchResultViewColumnDTO> searchResultViewColumnsDTO = searchResultViewDTO.getSearchResultViewColumns();
        if (searchResultViewColumnsDTO != null) {
            for (SearchResultViewColumnDTO searchResultViewColumnDTO : searchResultViewColumnsDTO) {
                SearchResultViewColumn searchResultViewColumn = this.convertSearchResultViewColumnDTOToSearchResultViewColumn(searchResultViewColumnDTO, searchResultView);
                searchResultViewColumn.setSearchResultView(searchResultView);
                searchResultViewColumns.add(searchResultViewColumn);
                this.searchResultViewColumnMap.put(searchResultViewColumn.getResultKey(), searchResultViewColumn);
            }
        }
        HashSet<SearchSQLGroup> searchSQLGroups = new HashSet<SearchSQLGroup>();
        List<SearchSQLGroupDTO> searchSQLGroupDTOs = searchResultViewDTO.getSearchSQLGroups();
        if (searchSQLGroupDTOs != null) {
            for (SearchSQLGroupDTO searchSQLGroupDTO : searchSQLGroupDTOs) {
                SearchSQLGroup searchSQLGroup = this.converSearchSQLGroupDTOtoSearchSQLGroup(searchSQLGroupDTO);
                if (searchSQLGroup == null) continue;
                searchSQLGroup.setSearchResultView(searchResultView);
                searchSQLGroups.add(searchSQLGroup);
                this.searchSQLGroupMap.put(searchSQLGroup.getGroupName(), searchSQLGroup);
            }
            if (searchSQLGroups.size() > 0) {
                searchResultView.setSearchSQLGroups(searchSQLGroups);
            }
        }
        searchResultView.setSearchResultViewColumns(this.fillSearchTableColumns(searchResultViewColumns, searchResultViewColumnsDTO));
        HashSet<SearchResultViewSort> searchResultViewSorts = new HashSet<SearchResultViewSort>();
        List<SearchResultViewSortDTO> searchResultViewSortDTOs = searchResultViewDTO.getSearchResultViewSorts();
        if (searchResultViewSortDTOs != null) {
            for (SearchResultViewSortDTO searchResultViewSortDTO : searchResultViewSortDTOs) {
                SearchResultViewSort searchResultViewSort = this.convertSearchResultViewSortDTOtoSearchResultViewSort(searchResultViewSortDTO);
                searchResultViewSort.setSearchResultView(searchResultView);
                searchResultViewSorts.add(searchResultViewSort);
            }
            searchResultView.setSearchResultViewSorts(searchResultViewSorts);
        }
        return searchResultView;
    }

    private SearchResultViewSort convertSearchResultViewSortDTOtoSearchResultViewSort(SearchResultViewSortDTO searchResultViewSortDTO) {
        SearchResultViewSort searchResultViewSort = new SearchResultViewSort();
        searchResultViewSort.setSortOrder(searchResultViewSortDTO.getSortOrder());
        searchResultViewSort.setSortSequence(searchResultViewSortDTO.getSortSequence());
        searchResultViewSort.setSearchResultViewColumn(this.searchResultViewColumnMap.get(searchResultViewSortDTO.getSearchResultViewColumn()));
        return searchResultViewSort;
    }

    private SearchSQLGroup converSearchSQLGroupDTOtoSearchSQLGroup(SearchSQLGroupDTO searchSQLGroupDTO) {
        if (!searchSQLGroupDTO.getGroupName().equals("")) {
            SearchSQLGroup sqlGroup = new SearchSQLGroup();
            sqlGroup.setId(null);
            sqlGroup.setGroupName(searchSQLGroupDTO.getGroupName());
            sqlGroup.setOrder(searchSQLGroupDTO.getGroupOrder());
            HashSet<SearchSQLGroupBy> searchSQLGroupBies = new HashSet<SearchSQLGroupBy>();
            List<SearchSQLGroupByDTO> searchSQLGroupByDTOs = searchSQLGroupDTO.getSearchSQLGroupBies();
            for (SearchSQLGroupByDTO searchSQLGroupByDTO : searchSQLGroupByDTOs) {
                SearchSQLGroupBy searchSQLGroupBy = this.convertSearchSQLGroupByDTOToSearchSQLGroupBy(searchSQLGroupByDTO);
                searchSQLGroupBy.setSearchSQLGroup(sqlGroup);
                searchSQLGroupBies.add(searchSQLGroupBy);
            }
            sqlGroup.setSearchSQLGroupBies(searchSQLGroupBies);
            return sqlGroup;
        }
        return null;
    }

    private SearchSQLGroupBy convertSearchSQLGroupByDTOToSearchSQLGroupBy(SearchSQLGroupByDTO searchSQLGroupByDTO) {
        SearchSQLGroupBy searchSQLGroupBy = new SearchSQLGroupBy();
        searchSQLGroupBy.setId(null);
        searchSQLGroupBy.setOrder(searchSQLGroupByDTO.getGroupByOrder());
        searchSQLGroupBy.setSearchResultViewColumn(this.searchResultViewColumnMap.get(searchSQLGroupByDTO.getSearchResultViewColumn()));
        return searchSQLGroupBy;
    }

    private Set<SearchResultViewColumn> fillSearchTableColumns(Set<SearchResultViewColumn> searchResultViewColumns, List<SearchResultViewColumnDTO> searchResultViewColumnsDTO) {
        HashSet<SearchResultViewColumn> filledSearchResultViewColumns = new HashSet<SearchResultViewColumn>();
        for (SearchResultViewColumn searchResultViewColumn : searchResultViewColumns) {
            String columnName = this.findColumnName(searchResultViewColumn.getResultKey(), searchResultViewColumnsDTO);
            if (searchResultViewColumn.getSearchConfigurationTable() == null) continue;
            String tableName = searchResultViewColumn.getSearchConfigurationTable().getSearchTableBySearchTableId().getDbTableName();
            SearchTableColumn searchTableColumn = ConfigurationHelper.getSearchTableColumn(tableName, columnName, this.searchTablesMap);
            searchResultViewColumn.setSearchTableColumn(searchTableColumn);
            String groupName = this.findGroupName(searchResultViewColumn.getResultKey(), searchResultViewColumnsDTO);
            if (groupName != null && !groupName.equals("")) {
                searchResultViewColumn.setSearchSQLGroup(this.searchSQLGroupMap.get(groupName));
            }
            filledSearchResultViewColumns.add(searchResultViewColumn);
        }
        return filledSearchResultViewColumns;
    }

    private String findColumnName(String resultKey, List<SearchResultViewColumnDTO> searchResultViewColumnsDTO) {
        for (SearchResultViewColumnDTO searchResultViewColumnDTO : searchResultViewColumnsDTO) {
            if (!searchResultViewColumnDTO.getResultKey().equals(resultKey)) continue;
            return searchResultViewColumnDTO.getSearchTableColumnName();
        }
        return null;
    }

    private String findGroupName(String resultKey, List<SearchResultViewColumnDTO> searchResultViewColumnsDTO) {
        for (SearchResultViewColumnDTO searchResultViewColumnDTO : searchResultViewColumnsDTO) {
            if (!searchResultViewColumnDTO.getResultKey().equals(resultKey) || searchResultViewColumnDTO.getSearchSQLGroupName() == null || searchResultViewColumnDTO.getSearchSQLGroupName() == null) continue;
            return searchResultViewColumnDTO.getSearchSQLGroupName();
        }
        return null;
    }

    public SearchResultViewColumn convertSearchResultViewColumnDTOToSearchResultViewColumn(SearchResultViewColumnDTO searchResultViewColumnDTO, SearchResultView searchResultView) {
        SearchResultViewColumn searchResultViewColumn = new SearchResultViewColumn();
        searchResultViewColumn.setId(null);
        searchResultViewColumn.setDisplayOrder(searchResultViewColumnDTO.getDisplayOrder());
        searchResultViewColumn.setDisplayCode(searchResultViewColumnDTO.getDisplayCode());
        searchResultViewColumn.setResultKey(searchResultViewColumnDTO.getResultKey());
        searchResultViewColumn.setVisibility(searchResultViewColumnDTO.getVisibility());
        if (searchResultViewColumnDTO.getSortable() == null) {
            searchResultViewColumn.setSortable(false);
        } else {
            searchResultViewColumn.setSortable(searchResultViewColumnDTO.getSortable());
        }
        searchResultViewColumn.setWhetherHyperlink(searchResultViewColumnDTO.getWhetherHyperlink());
        if (searchResultViewColumnDTO.getSqlFunction() != null) {
            searchResultViewColumn.setSqlFunction(searchResultViewColumnDTO.getSqlFunction());
        }
        if (searchResultViewColumnDTO.getSearchAggregateColumn() != null) {
            SearchAggregationColumn searchAggregationColumn = this.converSearchAggregateColumnDTOtoSearchAggregateColumn(searchResultViewColumnDTO.getSearchAggregateColumn());
            searchResultViewColumn.setSearchAggregationColumn(searchAggregationColumn);
        }
        if (searchResultViewColumnDTO.getFormatter() != null) {
            searchResultViewColumn.setFormatter(searchResultViewColumnDTO.getFormatter());
            SearchResultFormatterParamsDTO searchResultFormatterParamsDTO = searchResultViewColumnDTO.getSearchResultFormatterParams();
            SearchResultFormatterParams searchResultFormatterParams = new SearchResultFormatterParams();
            searchResultFormatterParams.setKey(searchResultFormatterParamsDTO.getFormatterParamskey());
            searchResultFormatterParams.setWhetherResultColumn(searchResultFormatterParamsDTO.getWhetherResultColumn());
            searchResultFormatterParams.setParam(searchResultFormatterParamsDTO.getResultColumnResultKey());
            searchResultViewColumn.setSearchResultFormatterParams(searchResultFormatterParams);
        }
        searchResultViewColumn.setSearchConfigurationTable(this.searchConfigTablesMap.get(searchResultViewColumnDTO.getSearchConfigTableAlias()));
        return searchResultViewColumn;
    }

    private SearchAggregationColumn converSearchAggregateColumnDTOtoSearchAggregateColumn(SearchAggregateColumnDTO searchAggregateColumn) {
        if (!searchAggregateColumn.getSearchTableId().equals("") && !searchAggregateColumn.getSearchTableColumnId().equals("")) {
            SearchAggregationColumn searchAggregationColumn = new SearchAggregationColumn();
            searchAggregationColumn.setId(null);
            searchAggregationColumn.setAliasName(searchAggregateColumn.getAliasName());
            searchAggregationColumn.setAggregateFunction(searchAggregateColumn.getAggregateFunction());
            searchAggregationColumn.setSearchTable(this.searchTablesMap.get(searchAggregateColumn.getSearchTableId()));
            searchAggregationColumn.setSearchTableColumn(ConfigurationHelper.getSearchTableColumn(searchAggregateColumn.getSearchTableId(), searchAggregateColumn.getSearchTableColumnId(), this.searchTablesMap));
            return searchAggregationColumn;
        }
        return null;
    }
}

