/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.licensegen.dao.impl;

import in.serosoft.licensegen.dao.LicenseGenDAO;
import in.serosoft.licensegen.domain.Entitlement;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="licenseGenDAO")
public class LicenseGenDAOImpl
implements LicenseGenDAO {
    protected SessionFactory sessionFactory;

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected Session getCrntSession() throws Exception {
        try {
            return this.sessionFactory.getCurrentSession();
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw new Exception("Failed to get thread session ", e);
        }
    }

    @Override
    public Entitlement findEntitlement() throws Exception {
        Entitlement entitlement = null;
        try {
            Session session = this.getCrntSession();
            Criteria criteria = session.createCriteria(Entitlement.class);
            List entitlements = criteria.list();
            if (entitlements.size() > 1) {
                throw new Exception("there_should_be_only_entitlement_record");
            }
            if (entitlements.size() == 1) {
                entitlement = (Entitlement)entitlements.get(0);
            }
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw new Exception("Failed to get thread session ", e);
        }
        return entitlement;
    }

    @Override
    public void update(Entitlement entitlement) throws Exception {
        Session session = this.getCrntSession();
        session.update(entitlement);
    }

    @Override
    public void create(Entitlement entitlement) throws Exception {
        Session session = this.getCrntSession();
        session.save(entitlement);
    }
}

