/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.sm.service.impl;

import in.serosoft.CriteriaBuilderConfigurer.DataConfigurerApp;
import in.serosoft.CriteriaBuilderConfigurer.PropertiesFileManager;
import in.serosoft.sm.dao.LoginPageContentUtilityDAO;
import in.serosoft.sm.service.LoginPageContentUtilityService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="loginPageContentUtilityService")
public class LoginPageContentUtilityServiceImpl
implements LoginPageContentUtilityService {
    @Autowired
    LoginPageContentUtilityDAO loginPageContentUtilityDAO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void generateContentFile() throws IOException {
        Map<String, List<String>> loginPageContentDataLst = this.loginPageContentUtilityDAO.getLoginPageContentData();
        Path targetPath = DataConfigurerApp.createDir(PropertiesFileManager.OUTPUT_DIRECTORY, "jsFiles");
        String sourceFilePath = "jsFiles/constants.js";
        Path targetFilePath = targetPath.resolve("constantscopy.js");
        InputStream inputStream = LoginPageContentUtilityServiceImpl.class.getClassLoader().getResourceAsStream(sourceFilePath);
        BufferedReader bufferReader = new BufferedReader(new InputStreamReader(inputStream));
        BufferedWriter bufferWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(targetPath.resolve("constantscopy.js"), new OpenOption[0])));
        String key = "homePage";
        try {
            String strCurrentLine;
            Set<String> pageNameLst = null;
            while ((strCurrentLine = bufferReader.readLine()) != null) {
                if (strCurrentLine.contains("PAGE:{")) {
                    pageNameLst = loginPageContentDataLst.keySet();
                    int pageContentCount = pageNameLst.size();
                    int count = 1;
                    bufferWriter.write("PAGE:{\n");
                    for (String pageContent : pageNameLst) {
                        if (pageContentCount == count) {
                            bufferWriter.write(pageContent + ":" + loginPageContentDataLst.get(pageContent).get(0).replace("\\\\", "\\") + "\n}\n};");
                        } else {
                            bufferWriter.write(pageContent + ":" + loginPageContentDataLst.get(pageContent).get(0).replace("\\\\", "\\") + ",\n");
                        }
                        ++count;
                    }
                    continue;
                }
                if (strCurrentLine.contains("SK:")) {
                    if (!loginPageContentDataLst.containsKey(key) || loginPageContentDataLst.get(key).size() <= 1) continue;
                    bufferWriter.write("\t\tSK:'" + loginPageContentDataLst.get(key).get(1) + "',\n");
                    continue;
                }
                if (strCurrentLine.contains("SECK:")) {
                    if (!loginPageContentDataLst.containsKey(key) || loginPageContentDataLst.get(key).size() <= 1) continue;
                    bufferWriter.write("\t\tSECK:'" + loginPageContentDataLst.get(key).get(2) + "',\n");
                    continue;
                }
                if (pageNameLst != null) continue;
                bufferWriter.write(strCurrentLine + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufferWriter != null) {
                    bufferWriter.close();
                }
                if (bufferReader != null) {
                    bufferReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        InputStream inputStreamR = Files.newInputStream(targetFilePath, new OpenOption[0]);
        BufferedReader bufferReaderR = new BufferedReader(new InputStreamReader(inputStreamR));
        BufferedWriter bufferWriterR = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(targetPath.resolve("constants.js"), new OpenOption[0])));
        try {
            String lineR;
            while ((lineR = bufferReaderR.readLine()) != null) {
                bufferWriterR.write(lineR);
                bufferWriterR.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufferWriterR != null) {
                    bufferWriterR.close();
                }
                if (bufferReaderR != null) {
                    bufferReaderR.close();
                }
                if (inputStreamR != null) {
                    inputStreamR.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

